/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Formatter;

public class DebugAssertions {
    private static final Logger LOG = Logger.getInstance(DebugAssertions.class);
    public static final boolean DEBUG = SystemProperties.getBooleanProperty((String)"intellij.idea.indices.debug", (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isEAP() ? 1 : 0) != 0);
    public static final boolean EXTRA_SANITY_CHECKS = SystemProperties.getBooleanProperty((String)"intellij.idea.indices.debug.extra.sanity", (boolean)false);

    public static void assertTrue(boolean value) {
        if (!value) {
            LOG.assertTrue(false);
        }
    }

    public static void assertTrue(boolean value, String message, Object ... args) {
        if (!value) {
            DebugAssertions.error(message, args);
        }
    }

    public static void error(String message, Object ... args) {
        LOG.error((Object)new Formatter().format(message, args));
    }

    static <Key> boolean equals(Collection<Key> keys, Collection<Key> keys2, KeyDescriptor<Key> keyDescriptor) {
        if (keys == null && keys2 == null) {
            return true;
        }
        if (keys == null || keys2 == null || keys.size() != keys2.size()) {
            return false;
        }
        LinkedHashMap map = new LinkedHashMap(keys.size(), 0.8f, keyDescriptor);
        for (Key key2 : keys) {
            map.put(key2, (Object)Boolean.TRUE);
        }
        LinkedHashMap map2 = new LinkedHashMap(keys.size(), 0.8f, keyDescriptor);
        for (Key key3 : keys2) {
            map2.put(key3, (Object)Boolean.TRUE);
        }
        return map.equals((Object)map2);
    }
}

