/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super("Refresh", "Re-read Commits From Disk for All VCS Roots and Rebuild Log", AllIcons.Actions.Refresh);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        VcsLogFilterer filterer;
        VcsLogUtil.triggerUsage(e);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(com.intellij.vcs.log.ui.VcsLogDataKeys.LOG_MANAGER);
        VcsLogUi ui = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui instanceof VcsLogUiImpl && !(filterer = ((VcsLogUiImpl)ui).getFilterer()).isValid()) {
            String message = "Trying to refresh invalid log tab.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
            filterer.setValid(true);
        }
        logManager.getDataManager().refreshCompletely();
    }

    @Override
    public void update(AnActionEvent e) {
        VcsLogManager logManager = (VcsLogManager)e.getData(com.intellij.vcs.log.ui.VcsLogDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }
}

