/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogRootFilterImpl;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFileFilter;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogFileFilter> {
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    public static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    public static final FileByPathComparator FILE_BY_PATH_COMPARATOR = new FileByPathComparator();
    public static final FilePathByNameComparator FILE_PATH_BY_NAME_COMPARATOR = new FilePathByNameComparator();
    public static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final VcsLogColorManager myColorManager;
    private final FixedSizeQueue<VcsLogStructureFilter> myHistory;

    public StructureFilterPopupComponent(@NotNull FilterModel<VcsLogFileFilter> filterModel, @NotNull VcsLogColorManager colorManager) {
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        super("Paths", filterModel);
        this.myHistory = new FixedSizeQueue(5);
        this.myColorManager = colorManager;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        Collection<Object> roots = filter.getRootFilter() == null ? this.getAllRoots() : filter.getRootFilter().getRoots();
        Set<FilePath> files = filter.getStructureFilter() == null ? Collections.emptySet() : filter.getStructureFilter().getFiles();
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), filter.getRootFilter(), filter.getStructureFilter());
        if (files.isEmpty()) {
            String string = StructureFilterPopupComponent.getTextFromRoots(roots, "roots", true, visibleRoots.size() == this.getAllRoots().size());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return string;
        }
        String string = StructureFilterPopupComponent.getTextFromFilePaths(files, "folders", false, files.isEmpty());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        return string;
    }

    private static String getTextFromRoots(@NotNull Collection<VirtualFile> files, @NotNull String category, boolean shorten, boolean full) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromRoots"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromRoots"));
        }
        return StructureFilterPopupComponent.getText(files, category, shorten ? FILE_BY_NAME_COMPARATOR : FILE_BY_PATH_COMPARATOR, file2 -> shorten ? file2.getName() : StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
    }

    private static String getTextFromFilePaths(@NotNull Collection<FilePath> files, @NotNull String category, boolean shorten, boolean full) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromFilePaths"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromFilePaths"));
        }
        return StructureFilterPopupComponent.getText(files, category, shorten ? FILE_PATH_BY_NAME_COMPARATOR : FILE_PATH_BY_PATH_COMPARATOR, file2 -> shorten ? file2.getName() : StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
    }

    private static <F> String getText(@NotNull Collection<F> files, @NotNull String category, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText, boolean full) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (getText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getText", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (full) {
            return "All";
        }
        if (files.isEmpty()) {
            return "No " + category;
        }
        F firstFile = Collections.min(files, comparator2);
        String firstFileName = (String)getText.fun(firstFile);
        if (files.size() == 1) {
            return firstFileName;
        }
        return firstFileName + " + " + (files.size() - 1);
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return this.getToolTip(filter.getRootFilter() == null ? this.getAllRoots() : filter.getRootFilter().getRoots(), filter.getStructureFilter() == null ? Collections.emptySet() : filter.getStructureFilter().getFiles());
    }

    @NotNull
    private String getToolTip(@NotNull Collection<VirtualFile> roots, @NotNull Collection<FilePath> files) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + "No Roots Selected";
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + "Roots:\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots, true);
        }
        if (!files.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + "Folders:\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files, false);
        }
        String string = tooltip;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return string;
    }

    private static String getTooltipTextForRoots(Collection<VirtualFile> files, boolean shorten) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, shorten ? FILE_BY_NAME_COMPARATOR : FILE_BY_PATH_COMPARATOR, file2 -> shorten ? file2.getName() : file2.getPresentableUrl());
    }

    private static String getTooltipTextForFilePaths(Collection<FilePath> files, boolean shorten) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, shorten ? FILE_PATH_BY_NAME_COMPARATOR : FILE_PATH_BY_PATH_COMPARATOR, file2 -> shorten ? file2.getName() : file2.getPresentableUrl());
    }

    private static <F> String getTooltipTextForFiles(@NotNull Collection<F> files, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        if (getText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getText", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        List filesToDisplay = ContainerUtil.sorted(files, comparator2);
        if (files.size() > 10) {
            filesToDisplay = filesToDisplay.subList(0, 10);
        }
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText, (String)"\n");
        if (files.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        return tooltip;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.isMultipleRoots()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.myHistory) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Recent"), new DefaultActionGroup(structureActions), new Separator("Roots"), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Roots"), new DefaultActionGroup(rootActions), new Separator("Recent"), new DefaultActionGroup(structureActions)});
    }

    private Set<VirtualFile> getAllRoots() {
        return this.myFilterModel.getDataPack().getLogProviders().keySet();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "isVisible"));
        }
        VcsLogFileFilter filter = (VcsLogFileFilter)this.myFilterModel.getFilter();
        if (filter != null && filter.getRootFilter() != null) {
            return filter.getRootFilter().getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "setVisible"));
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogFileFilter previousFilter = (VcsLogFileFilter)this.myFilterModel.getFilter();
        VcsLogRootFilter vcsLogRootFilter = rootFilter = previousFilter != null ? previousFilter.getRootFilter() : null;
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "setVisibleOnly"));
        }
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(Collections.singleton(root))));
    }

    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getStructureActionText"));
        }
        return StructureFilterPopupComponent.getTextFromFilePaths(filter.getFiles(), "items", false, filter.getFiles().isEmpty());
    }

    private static class FixedSizeQueue<T>
    implements Iterable<T> {
        private final LinkedList<T> myQueue = new LinkedList();
        private final int maxSize;

        public FixedSizeQueue(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = ContainerUtil.reverse(this.myQueue).iterator();
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$FixedSizeQueue", "iterator"));
            }
            return iterator;
        }

        public void add(T t) {
            this.myQueue.add(t);
            if (this.myQueue.size() > this.maxSize) {
                this.myQueue.poll();
            }
        }
    }

    private class SelectFromHistoryAction
    extends ToggleAction {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction", "<init>"));
            }
            super(StructureFilterPopupComponent.getStructureActionText(filter), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter.getFiles(), false).replace("\n", " "), null);
            this.myFilter = filter;
            this.myIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15);
            this.myEmptyIcon = EmptyIcon.create((int)15);
        }

        public boolean isSelected(AnActionEvent e) {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() != null && ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == this.myFilter;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        public static final String STRUCTURE_FILTER_TEXT = "Select Folders...";

        SelectFoldersAction() {
            super(STRUCTURE_FILTER_TEXT);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFoldersAction", "actionPerformed"));
            }
            Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = StructureFilterPopupComponent.this.myFilterModel.getDataPack();
            VcsLogFileFilter filter = (VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter();
            Collection<Object> files = filter == null || filter.getStructureFilter() == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)filter.getStructureFilter().getFiles(), filePath -> filePath.getVirtualFile());
            VcsStructureChooser chooser = new VcsStructureChooser(project2, "Select Files or Folders to Filter by", files, new ArrayList<VirtualFile>(dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                VcsLogStructureFilterImpl structureFilter = new VcsLogStructureFilterImpl((Set<VirtualFile>)new HashSet<VirtualFile>(chooser.getSelectedFiles()));
                StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(structureFilter, null));
                StructureFilterPopupComponent.this.myHistory.add(structureFilter);
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private final int mySize;
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        public CheckboxColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon", "<init>"));
            }
            super(size, color);
            this.mySelected = false;
            this.mySize = size;
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, this.mySize, this.mySize);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction", "<init>"));
            }
            super(root.getName(), root.getPresentableUrl(), null);
            this.myRoot = root;
            this.myIcon = new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager));
            this.getTemplatePresentation().setIcon(EmptyIcon.create((int)15));
        }

        public boolean isSelected(AnActionEvent e) {
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction", "update"));
            }
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            e.getPresentation().putClientProperty("ToolTipText", (Object)(KeyEvent.getKeyModifiersText(this.getMask()) + "+Click to see only \"" + e.getPresentation().getText() + "\""));
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() == null || ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == null;
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FilePathByNameComparator
    implements Comparator<FilePath> {
        private FilePathByNameComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class FileByPathComparator
    implements Comparator<VirtualFile> {
        private FileByPathComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

