/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.ReferencePopupBuilder;
import com.intellij.vcs.log.ui.render.VcsRefPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchesPanel
extends JPanel {
    private static final int SMALL_ROOTS_GAP = 3;
    private static final int BIG_ROOTS_GAP = 7;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsRefPainter myReferencePainter;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private LinkedHashMap<VirtualFile, List<RefGroup>> myRefGroups;
    @Nullable
    private Collection<VirtualFile> myRoots;

    public BranchesPanel(@NotNull VcsLogData logData, @NotNull VcsLogUiImpl ui, @NotNull VcsLogRefs initialRefsModel) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (initialRefsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRefsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        super(new FlowLayout(3, 1, 0));
        this.myRoots = null;
        this.setBorder(new EmptyBorder(2, 3, 3, 3));
        this.myLogData = logData;
        this.myUi = ui;
        this.myRefGroups = this.getRefsToDisplayOnPanel(initialRefsModel);
        this.myReferencePainter = new VcsRefPainter(this.myUi.getColorManager(), true);
        this.myScrollPane = new JBScrollPane((Component)this, 21, 32);
        this.myScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 0));
        this.myScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.recreateComponents();
    }

    @NotNull
    public JComponent getMainComponent() {
        JBScrollPane jBScrollPane = this.myScrollPane;
        if (jBScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getMainComponent"));
        }
        return jBScrollPane;
    }

    private void recreateComponents() {
        for (Map.Entry<VirtualFile, List<RefGroup>> entry : this.myRefGroups.entrySet()) {
            if (this.myRoots != null && !this.myRoots.contains(entry.getKey())) continue;
            this.add(new RootGroupComponent(entry.getValue(), entry.getKey()));
        }
    }

    public void rebuild(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "rebuild"));
        }
        this.myRefGroups = this.getRefsToDisplayOnPanel(refsModel);
        this.removeAll();
        this.recreateComponents();
        this.getParent().validate();
    }

    @NotNull
    private LinkedHashMap<VirtualFile, List<RefGroup>> getRefsToDisplayOnPanel(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        Collection allRefs = refsModel.getBranches();
        LinkedHashMap groups = ContainerUtil.newLinkedHashMap();
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            groups.put(entry.getKey(), BranchesPanel.expandExpandableGroups(this.myLogData.getLogProvider(entry.getKey()).getReferenceManager().group((Collection)entry.getValue())));
        }
        LinkedHashMap linkedHashMap = groups;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<RefGroup> expandExpandableGroups(@NotNull List<RefGroup> refGroups) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/frame/BranchesPanel", "expandExpandableGroups"));
        }
        ArrayList groups = ContainerUtil.newArrayList();
        for (RefGroup group : refGroups) {
            if (group.isExpanded() || group.getRefs().size() == 1) {
                groups.addAll(ContainerUtil.map((Collection)group.getRefs(), ref -> new SingletonRefGroup((VcsRef)ref)));
                continue;
            }
            groups.add(group);
        }
        ArrayList arrayList = groups;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel", "expandExpandableGroups"));
        }
        return arrayList;
    }

    public void onFiltersChange(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/frame/BranchesPanel", "onFiltersChange"));
        }
        this.myRoots = VcsLogUtil.getAllVisibleRoots(this.myLogData.getRoots(), filters.getRootFilter(), filters.getStructureFilter());
        this.removeAll();
        this.recreateComponents();
        this.getParent().validate();
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/BranchesPanel", "updateDataPack"));
        }
        if (permGraphChanged) {
            this.rebuild(dataPack.getRefs());
        }
    }

    public void setBranchPanelVisible(boolean visible) {
        this.myScrollPane.setVisible(visible);
    }

    private static class ReferenceGroupComponent
    extends JPanel {
        @NotNull
        private final RefGroup myGroup;
        @NotNull
        private final VcsRefPainter myReferencePainter;
        @NotNull
        private final VcsLogUiImpl myUi;
        @NotNull
        private final VirtualFile myRoot;

        private ReferenceGroupComponent(@NotNull RefGroup group, @NotNull VcsRefPainter referencePainter, @NotNull VcsLogUiImpl ui, @NotNull VirtualFile root) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferenceGroupComponent", "<init>"));
            }
            if (referencePainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePainter", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferenceGroupComponent", "<init>"));
            }
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferenceGroupComponent", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferenceGroupComponent", "<init>"));
            }
            this.myGroup = group;
            this.myReferencePainter = referencePainter;
            this.myUi = ui;
            this.myRoot = root;
            this.addMouseListener(new MyMouseAdapter());
        }

        @Override
        protected void paintComponent(Graphics g) {
            JBColor rootIndicatorColor = VcsLogColorManagerImpl.getIndicatorColor(this.myUi.getColorManager().getRootColor(this.myRoot));
            this.myReferencePainter.paint(this.myGroup.getName(), g, 0, (this.getHeight() - this.myReferencePainter.getHeight(this)) / 2, this.myGroup.getBgColor(), (Color)rootIndicatorColor);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myReferencePainter.getSize(this.myGroup.getName(), (JComponent)this);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private MyMouseAdapter() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ReferenceGroupComponent.this.myUi.areGraphActionsEnabled()) {
                    return;
                }
                if (ReferenceGroupComponent.this.myGroup.getRefs().size() == 1) {
                    VcsLogUtil.triggerUsage("BranchPanelGoToRef");
                    VcsRef ref = (VcsRef)ReferenceGroupComponent.this.myGroup.getRefs().iterator().next();
                    ReferenceGroupComponent.this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot());
                } else {
                    VcsLogUtil.triggerUsage("BranchPanelPopup");
                    ReferencePopupBuilder popupBuilder = new ReferencePopupBuilder(ReferenceGroupComponent.this.myGroup, ReferenceGroupComponent.this.myUi);
                    popupBuilder.getPopup().showUnderneathOf((Component)ReferenceGroupComponent.this);
                }
            }
        }
    }

    private class RootGroupComponent
    extends JPanel {
        @NotNull
        private final List<RefGroup> myGroups;

        private RootGroupComponent(@NotNull List<RefGroup> groups, VirtualFile root) {
            if (groups == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/vcs/log/ui/frame/BranchesPanel$RootGroupComponent", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/BranchesPanel$RootGroupComponent", "<init>"));
            }
            super(new FlowLayout(3, 3, 0));
            this.myGroups = groups;
            for (RefGroup group : this.myGroups) {
                this.add(new ReferenceGroupComponent(group, BranchesPanel.this.myReferencePainter, BranchesPanel.this.myUi, root));
            }
        }
    }
}

