/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XEvaluateInConsoleFromEditorActionHandler
extends XAddToWatchesFromEditorActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XEvaluateInConsoleFromEditorActionHandler", "isEnabled"));
        }
        return super.isEnabled(session2, dataContext) && XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2) != null;
    }

    @Nullable
    private static ConsoleExecuteAction getConsoleExecuteAction(@NotNull XDebugSession session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XEvaluateInConsoleFromEditorActionHandler", "getConsoleExecuteAction"));
        }
        return XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2.getConsoleView());
    }

    @Nullable
    public static ConsoleExecuteAction getConsoleExecuteAction(@Nullable ConsoleView consoleView) {
        if (!(consoleView instanceof LanguageConsoleView)) {
            return null;
        }
        List actions = ActionUtil.getActions((JComponent)((LanguageConsoleView)consoleView).getConsoleEditor().getComponent());
        ConsoleExecuteAction action = (ConsoleExecuteAction)((Object)ContainerUtil.findInstance((Iterable)actions, ConsoleExecuteAction.class));
        return action == null || !action.isEnabled() ? null : action;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        String text;
        TextRange range;
        int selectionEnd;
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XEvaluateInConsoleFromEditorActionHandler", "perform"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null || !(editor instanceof EditorEx)) {
            return;
        }
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        if (selectionStart != (selectionEnd = editor.getSelectionModel().getSelectionEnd())) {
            range = new TextRange(selectionStart, selectionEnd);
            text = editor.getDocument().getText(range);
        } else {
            XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
            if (evaluator != null) {
                ExpressionInfo expressionInfo = evaluator.getExpressionInfoAtOffset(session2.getProject(), editor.getDocument(), selectionStart, true);
                if (expressionInfo == null) {
                    return;
                }
                range = expressionInfo.getTextRange();
                text = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
            } else {
                return;
            }
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        ConsoleExecuteAction action = XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2);
        if (action != null) {
            action.execute(range, text, (EditorEx)editor);
        }
    }
}

