/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XQuickEvaluateHandler
extends QuickEvaluateHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler");

    @Override
    public boolean isEnabled(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "isEnabled"));
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        return session2 != null && session2.getDebugProcess().getEvaluator() != null;
    }

    @Override
    public AbstractValueHint createValueHint(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, ValueHintType type) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session2 == null) {
            return null;
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return null;
        }
        return (AbstractValueHint)PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "lambda$createValueHint$0"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "lambda$createValueHint$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "lambda$createValueHint$0"));
            }
            int offset = AbstractValueHint.calculateOffset(editor, point);
            ExpressionInfo expressionInfo = XQuickEvaluateHandler.getExpressionInfo(evaluator, project2, type, editor, offset);
            if (expressionInfo == null) {
                return null;
            }
            int textLength = editor.getDocument().getTextLength();
            TextRange range = expressionInfo.getTextRange();
            if (range.getStartOffset() > range.getEndOffset() || range.getStartOffset() < 0 || range.getEndOffset() > textLength) {
                LOG.error("invalid range: " + range + ", text length = " + textLength + ", evaluator: " + evaluator);
                return null;
            }
            return new XValueHint(project2, editor, point, type, expressionInfo, evaluator, session2);
        });
    }

    @Nullable
    private static ExpressionInfo getExpressionInfo(XDebuggerEvaluator evaluator, Project project2, ValueHintType type, Editor editor, int offset) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            return new ExpressionInfo(new TextRange(selectionStart, selectionEnd));
        }
        return evaluator.getExpressionInfoAtOffset(project2, editor.getDocument(), offset, type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT);
    }

    @Override
    public boolean canShowHint(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "canShowHint"));
        }
        return this.isEnabled(project2);
    }

    @Override
    public int getValueLookupDelay(Project project2) {
        return XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay();
    }
}

