/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    private final XWatchesView myWatchesView;
    private final WatchNode myOldNode;
    private WatchEditorSessionListener mySessionListener;

    public WatchInplaceEditor(@NotNull WatchesRootNode rootNode, @Nullable XDebugSession session2, XWatchesView watchesView, WatchNode node, @NonNls String historyId, @Nullable WatchNode oldNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor", "<init>"));
        }
        super((XDebuggerTreeNode)((Object)node), historyId);
        this.myRootNode = rootNode;
        this.myWatchesView = watchesView;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setExpression(oldNode != null ? oldNode.getExpression() : null);
        if (session2 != null) {
            this.mySessionListener = new WatchEditorSessionListener(session2).install();
        }
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myExpressionEditor.getComponent();
    }

    @Override
    public void cancelEditing() {
        if (!this.isShown()) {
            return;
        }
        super.cancelEditing();
        int index = this.myRootNode.getIndex(this.getNode());
        if (this.myOldNode == null && index != -1) {
            this.myRootNode.removeChildNode(this.getNode());
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.getNode());
    }

    @Override
    public void doOKAction() {
        XExpression expression = this.myExpressionEditor.getExpression();
        this.myExpressionEditor.saveTextInHistory();
        super.doOKAction();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (!XDebuggerUtilImpl.isEmptyExpression(expression) && index != -1) {
            this.myWatchesView.addWatchExpression(expression, index, false);
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.getNode());
    }

    @Override
    protected void onHidden() {
        super.onHidden();
        if (this.mySessionListener != null) {
            this.mySessionListener.remove();
        }
    }

    private class WatchEditorSessionListener
    implements XDebugSessionListener {
        private final XDebugSession mySession;

        public WatchEditorSessionListener(XDebugSession session2) {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor$WatchEditorSessionListener", "<init>"));
            }
            this.mySession = session2;
        }

        public WatchEditorSessionListener install() {
            this.mySession.addSessionListener((XDebugSessionListener)this);
            return this;
        }

        public void remove() {
            this.mySession.removeSessionListener((XDebugSessionListener)this);
        }

        private void cancel() {
            AppUIUtil.invokeOnEdt(WatchInplaceEditor.this::cancelEditing);
        }

        public void sessionPaused() {
            this.cancel();
        }

        public void beforeSessionResume() {
            this.cancel();
        }

        public void sessionResumed() {
            this.cancel();
        }

        public void sessionStopped() {
            this.cancel();
        }
    }
}

