/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueMarkers<V extends XValue, M> {
    private final XValueMarkerProvider<V, M> myProvider;
    private final Map<M, ValueMarkup> myMarkers;

    private XValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/xdebugger/impl/frame/XValueMarkers", "<init>"));
        }
        this.myProvider = provider;
        this.myMarkers = new HashMap<M, ValueMarkup>();
    }

    public static <V extends XValue, M> XValueMarkers<V, M> createValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/xdebugger/impl/frame/XValueMarkers", "createValueMarkers"));
        }
        return new XValueMarkers<V, M>(provider);
    }

    @Nullable
    public ValueMarkup getMarkup(@NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/frame/XValueMarkers", "getMarkup"));
        }
        Class valueClass = this.myProvider.getValueClass();
        if (!valueClass.isInstance(value)) {
            return null;
        }
        XValue v = (XValue)valueClass.cast(value);
        if (!this.myProvider.canMark(v)) {
            return null;
        }
        Object m = this.myProvider.getMarker(v);
        if (m == null) {
            return null;
        }
        return this.myMarkers.get(m);
    }

    public boolean canMarkValue(@NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/frame/XValueMarkers", "canMarkValue"));
        }
        Class valueClass = this.myProvider.getValueClass();
        if (!valueClass.isInstance(value)) {
            return false;
        }
        return this.myProvider.canMark((XValue)valueClass.cast(value));
    }

    public void markValue(@NotNull XValue value, @NotNull ValueMarkup markup) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/frame/XValueMarkers", "markValue"));
        }
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/xdebugger/impl/frame/XValueMarkers", "markValue"));
        }
        Object m = this.myProvider.markValue(value);
        this.myMarkers.put(m, markup);
    }

    public void unmarkValue(@NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/frame/XValueMarkers", "unmarkValue"));
        }
        XValue v = value;
        Object m = this.myProvider.getMarker(v);
        if (m != null) {
            this.myProvider.unmarkValue(v, m);
            this.myMarkers.remove(m);
        }
    }

    public Map<M, ValueMarkup> getAllMarkers() {
        return Collections.unmodifiableMap(this.myMarkers);
    }

    public void clear() {
        this.myMarkers.clear();
    }
}

