/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import com.jetbrains.jsonSchema.JsonSchemaMappingsView;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaConfigurable
extends NamedConfigurable<JsonSchemaMappingsConfigurationBase.SchemaInfo> {
    private final Project myProject;
    @NotNull
    private final String mySchemaFilePath;
    @NotNull
    private final JsonSchemaMappingsConfigurationBase.SchemaInfo mySchema;
    @Nullable
    private final Runnable myTreeUpdater;
    private JsonSchemaMappingsView myView;
    private String myDisplayName;
    private String myError;

    public JsonSchemaConfigurable(Project project2, @NotNull String schemaFilePath, @NotNull JsonSchemaMappingsConfigurationBase.SchemaInfo schema, @Nullable Runnable updateTree) {
        if (schemaFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFilePath", "com/jetbrains/jsonSchema/JsonSchemaConfigurable", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/JsonSchemaConfigurable", "<init>"));
        }
        super(true, updateTree);
        this.myProject = project2;
        this.mySchemaFilePath = schemaFilePath;
        this.mySchema = schema;
        this.myTreeUpdater = updateTree;
        this.myDisplayName = this.mySchema.getName();
    }

    @NotNull
    public JsonSchemaMappingsConfigurationBase.SchemaInfo getSchema() {
        JsonSchemaMappingsConfigurationBase.SchemaInfo schemaInfo = this.mySchema;
        if (schemaInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaConfigurable", "getSchema"));
        }
        return schemaInfo;
    }

    public void setDisplayName(String name) {
        this.myDisplayName = name;
    }

    public JsonSchemaMappingsConfigurationBase.SchemaInfo getEditableObject() {
        return this.mySchema;
    }

    public String getBannerSlogan() {
        return this.mySchema.getName();
    }

    public JComponent createOptionsPanel() {
        if (this.myView == null) {
            this.myView = new JsonSchemaMappingsView(this.myProject, this.myTreeUpdater);
            this.myView.setError(this.myError);
        }
        return this.myView.getComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.json.schema";
    }

    public boolean isModified() {
        if (this.myView == null) {
            return false;
        }
        if (!FileUtil.toSystemDependentName((String)this.mySchema.getRelativePathToSchema()).equals(this.myView.getSchemaSubPath())) {
            return false;
        }
        return !Comparing.equal(this.myView.getData(), this.mySchema.getPatterns());
    }

    public void apply() throws ConfigurationException {
        if (this.myView == null) {
            return;
        }
        this.doValidation();
        this.mySchema.setName(this.myDisplayName);
        this.mySchema.setPatterns(this.myView.getData());
        this.mySchema.setRelativePathToSchema(this.myView.getSchemaSubPath());
    }

    private void doValidation() throws ConfigurationException {
        File file2 = new File(this.myProject.getBasePath(), this.myView.getSchemaSubPath());
        VirtualFile vFile = null;
        if (!file2.exists() || (vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2)) == null) {
            throw new ConfigurationException((!StringUtil.isEmptyOrSpaces((String)this.myDisplayName) ? this.myDisplayName + ": " : "") + "Schema file does not exist");
        }
        String filename = file2.getName();
        if (StringUtil.isEmptyOrSpaces((String)this.myDisplayName)) {
            throw new ConfigurationException(filename + ": Schema name is empty");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myView.getSchemaSubPath())) {
            throw new ConfigurationException(filename + ": Schema path is empty");
        }
        CollectConsumer collectConsumer = new CollectConsumer();
        JsonSchemaService service = JsonSchemaService.Impl.get(this.myProject);
        if (service != null && !service.isSchemaFile(vFile, (Consumer<String>)collectConsumer)) {
            String message = collectConsumer.getResult().isEmpty() ? filename + ": Can not read JSON schema from file (Unknown reason)" : filename + ": Can not read JSON schema from file: " + StringUtil.join((Collection)collectConsumer.getResult(), (String)"; ");
            this.logErrorForUser(message);
            throw new RuntimeConfigurationWarning(message);
        }
    }

    private void logErrorForUser(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/jsonSchema/JsonSchemaConfigurable", "logErrorForUser"));
        }
        JsonSchemaReader.ERRORS_NOTIFICATION.createNotification(error, MessageType.ERROR).notify(this.myProject);
    }

    public void reset() {
        if (this.myView == null) {
            return;
        }
        this.myView.setItems(this.mySchemaFilePath, this.mySchema.getPatterns());
        this.setDisplayName(this.mySchema.getName());
    }

    public JsonSchemaMappingsConfigurationBase.SchemaInfo getUiSchema() {
        JsonSchemaMappingsConfigurationBase.SchemaInfo info = new JsonSchemaMappingsConfigurationBase.SchemaInfo();
        info.setApplicationLevel(this.mySchema.isApplicationLevel());
        if (this.myView != null && this.myView.isInitialized()) {
            info.setName(this.getDisplayName());
            info.setPatterns(this.myView.getData());
            info.setRelativePathToSchema(this.myView.getSchemaSubPath());
        } else {
            info.setName(this.mySchema.getName());
            info.setPatterns(this.mySchema.getPatterns());
            info.setRelativePathToSchema(this.mySchema.getRelativePathToSchema());
        }
        return info;
    }

    public void disposeUIResources() {
        if (this.myView != null) {
            Disposer.dispose((Disposable)this.myView);
        }
    }

    public void setError(String error) {
        this.myError = error;
        if (this.myView != null) {
            this.myView.setError(error);
        }
    }
}

