/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaFileTypeManager
implements ProjectManagerListener {
    private final Collection<VirtualFile> myFileSets = ContainerUtil.createConcurrentList();
    private volatile boolean mySetsInitialized;
    private static final Object LOCK = new Object();

    public static JsonSchemaFileTypeManager getInstance() {
        return (JsonSchemaFileTypeManager)ServiceManager.getService(JsonSchemaFileTypeManager.class);
    }

    public JsonSchemaFileTypeManager() {
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
    }

    public boolean isJsonSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/JsonSchemaFileTypeManager", "isJsonSchemaFile"));
        }
        this.ensureInitialized();
        return this.myFileSets.contains(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (this.mySetsInitialized) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            Project[] openProjects;
            if (this.mySetsInitialized) {
                return;
            }
            this.myFileSets.clear();
            for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                this.myFileSets.addAll(JsonSchemaService.Impl.getEx(openProject).getSchemaFiles());
            }
            this.mySetsInitialized = true;
        }
    }

    public void projectOpened(Project project2) {
        this.reset();
    }

    public void reset() {
        this.mySetsInitialized = false;
        this.ensureInitialized();
    }

    public boolean canCloseProject(Project project2) {
        return true;
    }

    public void projectClosed(Project project2) {
        this.reset();
    }

    public void projectClosing(Project project2) {
    }
}

