/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaProjectSelfProviderFactory
implements JsonSchemaProviderFactory {
    public static final String SCHEMA_JSON_FILE_NAME = "schema.json";
    private final List<JsonSchemaFileProvider> myProviders = Collections.singletonList(new MyJsonSchemaFileProvider());

    @Override
    public List<JsonSchemaFileProvider> getProviders(@Nullable Project project2) {
        return this.myProviders;
    }

    private static class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        public static final Pair<SchemaType, Object> KEY = Pair.create((Object)((Object)SchemaType.schema), (Object)((Object)SchemaType.schema));
        private final VirtualFile mySchemaFile = JsonSchemaProviderFactory.getResourceFile(JsonSchemaProjectSelfProviderFactory.class, "/jsonSchema/schema.json");

        private MyJsonSchemaFileProvider() {
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider", "isAvailable"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider", "isAvailable"));
            }
            if (!JsonSchemaFileType.INSTANCE.equals(file2.getFileType())) {
                return false;
            }
            return JsonSchemaMappingsProjectConfiguration.getInstance(project2).isRegisteredSchemaFile(file2);
        }

        @Override
        @NotNull
        public String getName() {
            if (JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider", "getName"));
            }
            return JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME;
        }

        @Override
        public VirtualFile getSchemaFile() {
            return this.mySchemaFile;
        }

        @Override
        public SchemaType getSchemaType() {
            return SchemaType.schema;
        }
    }
}

