/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IteratorUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopConditionNotUpdatedInsideLoopInspection
extends BaseInspection {
    public boolean ignoreIterators = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean entireCondition = (Boolean)infos[0];
        if (entireCondition) {
            String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.iterator.loop.variables", new Object[0]), (InspectionProfileEntry)this, "ignoreIterators");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopConditionNotUpdatedInsideLoopVisitor();
    }

    private class LoopConditionNotUpdatedInsideLoopVisitor
    extends BaseInspectionVisitor {
        private LoopConditionNotUpdatedInsideLoopVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            this.check(condition, (PsiStatement)statement2);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            this.check(condition, (PsiStatement)statement2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            this.check(condition, (PsiStatement)statement2);
        }

        private void check(PsiExpression condition, PsiStatement statement2) {
            SmartList notUpdated = new SmartList();
            if (this.checkCondition(condition, statement2, (List<PsiExpression>)notUpdated)) {
                if (notUpdated.isEmpty()) {
                    if (!BoolUtils.isTrue(condition)) {
                        this.registerError((PsiElement)condition, Boolean.TRUE);
                    }
                } else {
                    for (PsiExpression expression : notUpdated) {
                        this.registerError((PsiElement)expression, Boolean.FALSE);
                    }
                }
            }
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @NotNull PsiStatement context, List<PsiExpression> notUpdated) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection$LoopConditionNotUpdatedInsideLoopVisitor", "checkCondition"));
            }
            if (condition == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)condition) || ExpressionUtils.isNullLiteral(condition)) {
                return true;
            }
            if (condition instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)condition;
                PsiExpression operand = instanceOfExpression.getOperand();
                return this.checkCondition(operand, context, notUpdated);
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiExpression expression = ((PsiParenthesizedExpression)condition).getExpression();
                return this.checkCondition(expression, context, notUpdated);
            }
            if (condition instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (this.checkCondition(operand, context, notUpdated)) continue;
                    return false;
                }
                return true;
            }
            if (condition instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)condition;
                PsiElement element = referenceExpression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType type = field.getType();
                    if (field.hasModifierProperty("final") && type.getArrayDimensions() == 0) {
                        if (field.hasModifierProperty("static")) {
                            return true;
                        }
                        PsiExpression qualifier = referenceExpression.getQualifierExpression();
                        if (qualifier == null) {
                            return true;
                        }
                        if (this.checkCondition(qualifier, context, notUpdated)) {
                            return true;
                        }
                    }
                } else if (element instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)element;
                    if (variable.hasModifierProperty("final")) {
                        return true;
                    }
                    if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                        PsiType type = variable.getType();
                        if (!(VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context) || type instanceof PsiArrayType && VariableAccessUtils.arrayContentsAreAssigned(variable, (PsiElement)context))) {
                            notUpdated.add((PsiExpression)referenceExpression);
                            return true;
                        }
                    }
                }
            } else if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                if (JavaTokenType.EXCL.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType)) {
                    PsiExpression operand = prefixExpression.getOperand();
                    return this.checkCondition(operand, context, notUpdated);
                }
            } else {
                if (condition instanceof PsiArrayAccessExpression) {
                    PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)condition;
                    PsiExpression indexExpression = accessExpression.getIndexExpression();
                    return this.checkCondition(indexExpression, context, notUpdated) && this.checkCondition(accessExpression.getArrayExpression(), context, notUpdated);
                }
                if (condition instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)condition;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    if (thenExpression == null || elseExpression == null) {
                        return false;
                    }
                    return this.checkCondition(conditionalExpression.getCondition(), context, notUpdated) && this.checkCondition(thenExpression, context, notUpdated) && this.checkCondition(elseExpression, context, notUpdated);
                }
                if (condition instanceof PsiThisExpression) {
                    return true;
                }
                if (condition instanceof PsiMethodCallExpression && !LoopConditionNotUpdatedInsideLoopInspection.this.ignoreIterators) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition;
                    if (!IteratorUtils.isCallToHasNext(methodCallExpression)) {
                        return false;
                    }
                    PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                    PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                    if (qualifierExpression instanceof PsiReferenceExpression) {
                        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                        PsiElement element = referenceExpression.resolve();
                        if (!(element instanceof PsiVariable)) {
                            return false;
                        }
                        PsiVariable variable = (PsiVariable)element;
                        if (!IteratorUtils.containsCallToScannerNext((PsiElement)context, variable, true)) {
                            notUpdated.add(qualifierExpression);
                            return true;
                        }
                    } else if (!IteratorUtils.containsCallToScannerNext((PsiElement)context, null, true)) {
                        notUpdated.add((PsiExpression)methodCallExpression);
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

