/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryBreakInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.break.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryBreakInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.break.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryBreakInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("break");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBreakVisitor();
    }

    private static class UnnecessaryBreakVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBreakVisitor() {
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            super.visitBreakStatement(statement2);
            PsiIdentifier identifier = statement2.getLabelIdentifier();
            if (identifier == null) {
                return;
            }
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null || exitedStatement instanceof PsiSwitchStatement) {
                return;
            }
            if (exitedStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)exitedStatement;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)statement2)) {
                    this.registerStatementError((PsiStatement)statement2, new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement(exitedStatement, (PsiStatement)statement2)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }
    }
}

