/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantConditionalExpression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getID"));
        }
        return "RedundantConditionalExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", UnnecessaryConditionalExpressionInspection.calculateReplacementExpression(expression));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    static String calculateReplacementExpression(PsiConditionalExpression exp) {
        PsiExpression thenExpression = exp.getThenExpression();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression condition = exp.getCondition();
        if (BoolUtils.isFalse(thenExpression) && BoolUtils.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConditionalFix();
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            if (BoolUtils.isFalse(thenExpression) && BoolUtils.isTrue(elseExpression) || BoolUtils.isTrue(thenExpression) && BoolUtils.isFalse(elseExpression)) {
                this.registerError((PsiElement)expression, expression);
            }
        }
    }

    private static class UnnecessaryConditionalFix
    extends InspectionGadgetsFix {
        private UnnecessaryConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiConditionalExpression expression = (PsiConditionalExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryConditionalExpressionInspection.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

