/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CheckForOutOfMemoryOnLargeArrayAllocationInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.maximum.number.of.elements.option", new Object[0]), (InspectionProfileEntry)this, "m_limit", 5);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CheckForOutOfMemoryOnLargeArrayAllocationVisitor();
    }

    private class CheckForOutOfMemoryOnLargeArrayAllocationVisitor
    extends BaseInspectionVisitor {
        private CheckForOutOfMemoryOnLargeArrayAllocationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] dimensions;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection$CheckForOutOfMemoryOnLargeArrayAllocationVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            int size = 1;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                Integer intValue = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)dimension, (PsiType)PsiType.INT);
                if (intValue == null) continue;
                size *= intValue.intValue();
            }
            if (size <= CheckForOutOfMemoryOnLargeArrayAllocationInspection.this.m_limit) {
                return;
            }
            if (this.outOfMemoryExceptionCaught((PsiElement)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private boolean outOfMemoryExceptionCaught(PsiElement element) {
            PsiElement currentElement = element;
            PsiTryStatement containingTryStatement;
            while ((containingTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class)) != null) {
                if (this.catchesOutOfMemoryException(containingTryStatement)) {
                    return true;
                }
                currentElement = containingTryStatement;
            }
            return false;
        }

        private boolean catchesOutOfMemoryException(PsiTryStatement statement2) {
            PsiCatchSection[] sections;
            for (PsiCatchSection section : sections = statement2.getCatchSections()) {
                String typeText;
                PsiType catchType = section.getCatchType();
                if (catchType == null || !"java.lang.OutOfMemoryError".equals(typeText = catchType.getCanonicalText())) continue;
                return true;
            }
            return false;
        }
    }
}

