/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousInnerClassMayBeStaticInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/AnonymousInnerClassMayBeStaticInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/AnonymousInnerClassMayBeStaticInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousInnerClassMayBeStaticVisitor();
    }

    private static class AnonymousInnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private AnonymousInnerClassMayBeStaticVisitor() {
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass anonymousClass) {
            if (anonymousClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/siyeh/ig/memory/AnonymousInnerClassMayBeStaticInspectionBase$AnonymousInnerClassMayBeStaticVisitor", "visitAnonymousClass"));
            }
            if (anonymousClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            PsiMember containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)anonymousClass, PsiMember.class);
            if (containingMember == null || containingMember.hasModifierProperty("static")) {
                return;
            }
            PsiJavaCodeReferenceElement reference = anonymousClass.getBaseClassReference();
            if (reference.resolve() == null) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)anonymousClass, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                return;
            }
            InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor((PsiClass)anonymousClass);
            anonymousClass.accept((PsiElementVisitor)visitor);
            if (!visitor.canInnerClassBeStatic()) {
                return;
            }
            if (AnonymousInnerClassMayBeStaticVisitor.hasReferenceToLocalClass(anonymousClass)) {
                return;
            }
            this.registerClassError((PsiClass)anonymousClass, new Object[0]);
        }

        private static boolean hasReferenceToLocalClass(PsiAnonymousClass anonymousClass) {
            LocalClassReferenceVisitor visitor = new LocalClassReferenceVisitor();
            anonymousClass.accept((PsiElementVisitor)visitor);
            return visitor.hasReferenceToLocalClass();
        }

        private static class LocalClassReferenceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private boolean referenceToLocalClass;

            private LocalClassReferenceVisitor() {
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (reference.getQualifier() != null) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass) || !PsiUtil.isLocalClass((PsiClass)((PsiClass)target))) {
                    return;
                }
                this.referenceToLocalClass = true;
            }

            private boolean hasReferenceToLocalClass() {
                return this.referenceToLocalClass;
            }
        }
    }
}

