/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtils {
    private ExpectedTypeUtils() {
    }

    @Nullable
    public static PsiType findExpectedType(@NotNull PsiExpression expression, boolean calculateTypeForComplexReferences) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpectedTypeUtils", "findExpectedType"));
        }
        return ExpectedTypeUtils.findExpectedType(expression, calculateTypeForComplexReferences, false);
    }

    public static PsiType findExpectedType(PsiExpression expression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
        PsiElement context = expression.getParent();
        PsiExpression wrappedExpression = expression;
        while (context instanceof PsiParenthesizedExpression) {
            wrappedExpression = (PsiExpression)context;
            context = context.getParent();
        }
        if (context == null) {
            return null;
        }
        ExpectedTypeVisitor visitor = new ExpectedTypeVisitor(wrappedExpression, calculateTypeForComplexReferences, reportCasts);
        context.accept((PsiElementVisitor)visitor);
        return visitor.getExpectedType();
    }

    private static class ExpectedTypeVisitor
    extends JavaElementVisitor {
        private static final Set<IElementType> arithmeticOps = new THashSet(5);
        private static final Set<IElementType> booleanOps = new THashSet(5);
        private static final Set<IElementType> shiftOps = new THashSet(3);
        private static final Set<IElementType> operatorAssignmentOps = new THashSet(11);
        @NotNull
        private final PsiExpression wrappedExpression;
        private final boolean calculateTypeForComplexReferences;
        private final boolean reportCasts;
        private PsiType expectedType;

        ExpectedTypeVisitor(@NotNull PsiExpression wrappedExpression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
            if (wrappedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedExpression", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "<init>"));
            }
            this.expectedType = null;
            this.wrappedExpression = wrappedExpression;
            this.calculateTypeForComplexReferences = calculateTypeForComplexReferences;
            this.reportCasts = reportCasts;
        }

        public PsiType getExpectedType() {
            return this.expectedType;
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitField"));
            }
            PsiExpression initializer = field.getInitializer();
            if (this.wrappedExpression.equals(initializer)) {
                this.expectedType = field.getType();
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitVariable"));
            }
            this.expectedType = variable.getType();
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
            PsiExpression condition = statement2.getAssertCondition();
            this.expectedType = this.wrappedExpression == condition ? PsiType.BOOLEAN : TypeUtils.getStringType((PsiElement)statement2);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression initializer) {
            PsiType type = initializer.getType();
            if (!(type instanceof PsiArrayType)) {
                this.expectedType = null;
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            this.expectedType = arrayType.getComponentType();
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression accessExpression) {
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            if (this.wrappedExpression.equals(indexExpression)) {
                this.expectedType = PsiType.INT;
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression) {
            if (polyadicExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitPolyadicExpression"));
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length < 2) {
                this.expectedType = null;
                return;
            }
            for (PsiExpression operand : operands) {
                if (operand != null && operand.getType() != null) continue;
                this.expectedType = null;
                return;
            }
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiType type = polyadicExpression.getType();
            PsiType wrappedExpressionType = this.wrappedExpression.getType();
            if (TypeUtils.isJavaLangString(type) || ExpectedTypeVisitor.isArithmeticOperation(tokenType) || ExpectedTypeVisitor.isBooleanOperation(tokenType)) {
                this.expectedType = type;
            } else if (ExpectedTypeVisitor.isShiftOperation(tokenType)) {
                this.expectedType = TypeUtils.unaryNumericPromotion(wrappedExpressionType);
            } else if (ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                PsiExpression operand1 = operands[0];
                PsiExpression operand2 = operands[1];
                if (operand1 == this.wrappedExpression || operand2 == this.wrappedExpression) {
                    PsiType type1 = operand1.getType();
                    PsiType type2 = operand2.getType();
                    this.expectedType = type1 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type1, type2) : (type2 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type2, type1) : TypeUtils.getObjectType((PsiElement)this.wrappedExpression));
                } else {
                    this.expectedType = TypeConversionUtil.isBooleanType((PsiType)wrappedExpressionType) ? PsiType.BOOLEAN : null;
                }
            } else if (ComparisonUtils.isComparisonOperation(tokenType)) {
                if (operands.length != 2) {
                    this.expectedType = null;
                    return;
                }
                if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)wrappedExpressionType) && PsiPrimitiveType.getUnboxedType((PsiType)wrappedExpressionType) == null) {
                    return;
                }
                this.expectedType = TypeConversionUtil.binaryNumericPromotion((PsiType)operands[0].getType(), (PsiType)operands[1].getType());
            } else {
                this.expectedType = null;
            }
        }

        private PsiType expectedPrimitiveType(PsiPrimitiveType type1, PsiType type2) {
            if (TypeConversionUtil.isNumericType((PsiType)type1)) {
                return TypeConversionUtil.isNumericType((PsiType)type2) ? TypeConversionUtil.binaryNumericPromotion((PsiType)type1, (PsiType)type2) : null;
            }
            if (PsiType.BOOLEAN.equals((Object)type1)) {
                return TypeConversionUtil.isBooleanType((PsiType)type2) ? PsiType.BOOLEAN : null;
            }
            if (PsiType.NULL.equals((Object)type1)) {
                return TypeUtils.getObjectType((PsiElement)this.wrappedExpression);
            }
            return null;
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitPrefixExpression"));
            }
            PsiType type = expression.getType();
            this.expectedType = type instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType((PsiType)type);
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitPostfixExpression"));
            }
            PsiType type = expression.getType();
            this.expectedType = type instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType((PsiType)type);
        }

        public void visitSwitchStatement(PsiSwitchStatement statement2) {
            PsiExpression expression = statement2.getExpression();
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
            this.expectedType = unboxedType != null ? unboxedType : type;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            if (this.reportCasts) {
                this.expectedType = expression.getType();
            }
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitWhileStatement"));
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitForStatement"));
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                this.expectedType = null;
                return;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            if (!(iteratedValueType instanceof PsiClassType)) {
                this.expectedType = null;
                return;
            }
            PsiClassType classType = (PsiClassType)iteratedValueType;
            PsiType[] parameters = classType.getParameters();
            PsiClass iterableClass = ClassUtils.findClass("java.lang.Iterable", (PsiElement)statement2);
            this.expectedType = iterableClass == null ? null : JavaPsiFacade.getElementFactory((Project)statement2.getProject()).createType(iterableClass, parameters);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitIfStatement"));
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitDoWhileStatement"));
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitSynchronizedStatement"));
            }
            this.expectedType = TypeUtils.getObjectType((PsiElement)statement2);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitAssignmentExpression"));
            }
            PsiExpression rExpression = assignment.getRExpression();
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression lExpression = assignment.getLExpression();
            PsiType lType = lExpression.getType();
            this.expectedType = rExpression != null && this.wrappedExpression.equals(rExpression) ? (lType == null ? null : (TypeUtils.isJavaLangString(lType) ? (JavaTokenType.PLUSEQ.equals(tokenType) ? rExpression.getType() : lType) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) ? (lType instanceof PsiPrimitiveType ? lType : PsiPrimitiveType.getUnboxedType((PsiType)lType)) : lType))) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) && !(lType instanceof PsiPrimitiveType) ? PsiPrimitiveType.getUnboxedType((PsiType)lType) : lType);
        }

        public void visitConditionalExpression(PsiConditionalExpression conditional) {
            PsiExpression condition = conditional.getCondition();
            this.expectedType = condition.equals(this.wrappedExpression) ? PsiType.BOOLEAN : conditional.getType();
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitReturnStatement"));
            }
            PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (method instanceof PsiMethod) {
                this.expectedType = ((PsiMethod)method).getReturnType();
            } else if (method instanceof PsiLambdaExpression) {
                this.expectedType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)method));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
            this.expectedType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            this.expectedType = TypeUtils.getObjectType((PsiElement)expression);
        }

        public void visitDeclarationStatement(PsiDeclarationStatement declaration) {
            PsiElement[] declaredElements;
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiVariable variable;
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiVariable) || !this.wrappedExpression.equals(initializer = (variable = (PsiVariable)declaredElement).getInitializer())) continue;
                this.expectedType = variable.getType();
                return;
            }
        }

        public void visitExpressionList(PsiExpressionList expressionList) {
            JavaResolveResult result2 = ExpectedTypeVisitor.findCalledMethod(expressionList);
            PsiMethod method = (PsiMethod)result2.getElement();
            if (method == null) {
                this.expectedType = null;
            } else {
                int parameterPosition = ExpectedTypeVisitor.getParameterPosition(expressionList, this.wrappedExpression);
                this.expectedType = ExpectedTypeVisitor.getTypeOfParameter(result2, parameterPosition);
            }
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            for (PsiExpression arrayDimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.wrappedExpression.equals(arrayDimension)) continue;
                this.expectedType = PsiType.INT;
            }
        }

        @NotNull
        private static JavaResolveResult findCalledMethod(PsiExpressionList expressionList) {
            PsiElement grandParent;
            PsiElement parent = expressionList.getParent();
            if (parent instanceof PsiCallExpression) {
                PsiCallExpression call = (PsiCallExpression)parent;
                JavaResolveResult javaResolveResult = call.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "findCalledMethod"));
                }
                return javaResolveResult;
            }
            if (parent instanceof PsiAnonymousClass && (grandParent = parent.getParent()) instanceof PsiCallExpression) {
                PsiCallExpression callExpression = (PsiCallExpression)grandParent;
                JavaResolveResult javaResolveResult = callExpression.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "findCalledMethod"));
                }
                return javaResolveResult;
            }
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "findCalledMethod"));
            }
            return javaResolveResult;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "visitReferenceExpression"));
            }
            if (this.calculateTypeForComplexReferences) {
                Project project2 = referenceExpression.getProject();
                JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    if (!ExpectedTypeVisitor.isAccessibleFrom((PsiMember)field, (PsiElement)referenceExpression)) {
                        return;
                    }
                    PsiClass aClass = field.getContainingClass();
                    if (aClass == null) {
                        return;
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else if (element instanceof PsiMethod) {
                    PsiClass aClass;
                    PsiMethodCallExpression methodCallExpression;
                    PsiType type;
                    PsiElement parent = referenceExpression.getParent();
                    PsiType returnType = parent instanceof PsiMethodCallExpression ? (!PsiType.VOID.equals((Object)(type = (methodCallExpression = (PsiMethodCallExpression)parent).getType())) ? ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, true) : null) : null;
                    PsiMethod method = (PsiMethod)element;
                    PsiMethod superMethod = ExpectedTypeVisitor.findDeepestVisibleSuperMethod(method, returnType, (PsiElement)referenceExpression);
                    if (superMethod != null) {
                        aClass = superMethod.getContainingClass();
                        if (aClass == null) {
                            return;
                        }
                        substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)method.getContainingClass(), (PsiSubstitutor)substitutor);
                    } else {
                        aClass = method.getContainingClass();
                        if (aClass == null) {
                            return;
                        }
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else {
                    this.expectedType = null;
                }
            }
        }

        @Nullable
        private static PsiMethod findDeepestVisibleSuperMethod(PsiMethod method, PsiType returnType, PsiElement element) {
            if (method.isConstructor()) {
                return null;
            }
            if (method.hasModifierProperty("static")) {
                return null;
            }
            if (method.hasModifierProperty("private")) {
                return null;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            HashSet thrownTypes = ContainerUtil.newHashSet((Object[])throwsList.getReferencedTypes());
            PsiMethod[] superMethods = aClass.findMethodsBySignature(method, true);
            PsiMethod topSuper = null;
            PsiClass topSuperContainingClass = null;
            block0: for (PsiMethod superMethod : superMethods) {
                PsiClassType[] superThrownTypes;
                PsiType superReturnType;
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || aClass.equals(superClass) || !ExpectedTypeVisitor.isAccessibleFrom((PsiMember)superMethod, element) || returnType != null && ((superReturnType = superMethod.getReturnType()) == null || !returnType.isAssignableFrom(superReturnType)) || topSuper != null && superClass.isInheritor(topSuperContainingClass, true)) continue;
                PsiReferenceList superThrowsList = superMethod.getThrowsList();
                for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
                    if (!ExceptionUtil.isUncheckedException(superThrownType) && !thrownTypes.contains(superThrownType)) continue block0;
                }
                topSuper = superMethod;
                topSuperContainingClass = superClass;
            }
            return topSuper;
        }

        private static boolean isAccessibleFrom(PsiMember member, PsiElement referencingLocation) {
            if (member.hasModifierProperty("public")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiClass referencingClass = ClassUtils.getContainingClass(referencingLocation);
            if (referencingClass == null) {
                return false;
            }
            if (referencingClass.equals(containingClass)) {
                return true;
            }
            if (member.hasModifierProperty("private")) {
                return false;
            }
            return ClassUtils.inSamePackage((PsiElement)containingClass, referencingLocation);
        }

        private static boolean isArithmeticOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "isArithmeticOperation"));
            }
            return arithmeticOps.contains(sign);
        }

        private static boolean isBooleanOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "isBooleanOperation"));
            }
            return booleanOps.contains(sign);
        }

        private static boolean isShiftOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "isShiftOperation"));
            }
            return shiftOps.contains(sign);
        }

        private static boolean isOperatorAssignmentOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "isOperatorAssignmentOperation"));
            }
            return operatorAssignmentOps.contains(sign);
        }

        private static int getParameterPosition(@NotNull PsiExpressionList expressionList, PsiExpression expression) {
            if (expressionList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionList", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "getParameterPosition"));
            }
            return ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)expression);
        }

        @Nullable
        private static PsiType getTypeOfParameter(@NotNull JavaResolveResult result2, int parameterPosition) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor", "getTypeOfParameter"));
            }
            PsiMethod method = (PsiMethod)result2.getElement();
            if (method == null) {
                return null;
            }
            PsiSubstitutor substitutor = result2.getSubstitutor();
            PsiParameterList parameterList = method.getParameterList();
            if (parameterPosition < 0) {
                return null;
            }
            int parametersCount = parameterList.getParametersCount();
            if (parameterPosition >= parametersCount) {
                int lastParameterPosition = parametersCount - 1;
                if (lastParameterPosition < 0) {
                    return null;
                }
                PsiParameter[] parameters = parameterList.getParameters();
                PsiParameter lastParameter = parameters[lastParameterPosition];
                if (lastParameter.isVarArgs()) {
                    PsiArrayType arrayType = (PsiArrayType)lastParameter.getType();
                    return substitutor.substitute(arrayType.getComponentType());
                }
                return null;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[parameterPosition];
            PsiType parameterType = parameter.getType();
            if (parameter.isVarArgs()) {
                PsiArrayType arrayType = (PsiArrayType)parameterType;
                return substitutor.substitute(arrayType.getComponentType());
            }
            PsiType type = GenericsUtil.getVariableTypeByExpressionType((PsiType)substitutor.substitute(parameterType));
            if (type == null) {
                return null;
            }
            TypeStringCreator typeStringCreator = new TypeStringCreator();
            type.accept((PsiTypeVisitor)typeStringCreator);
            if (typeStringCreator.isModified()) {
                PsiManager manager = method.getManager();
                Project project2 = manager.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                try {
                    String typeString = typeStringCreator.getTypeString();
                    return factory.createTypeFromText(typeString, (PsiElement)method);
                }
                catch (IncorrectOperationException e) {
                    throw new AssertionError((Object)("incorrect type string generated from " + type + ": " + e.getMessage()));
                }
            }
            return type;
        }

        static {
            arithmeticOps.add(JavaTokenType.PLUS);
            arithmeticOps.add(JavaTokenType.MINUS);
            arithmeticOps.add(JavaTokenType.ASTERISK);
            arithmeticOps.add(JavaTokenType.DIV);
            arithmeticOps.add(JavaTokenType.PERC);
            booleanOps.add(JavaTokenType.ANDAND);
            booleanOps.add(JavaTokenType.AND);
            booleanOps.add(JavaTokenType.XOR);
            booleanOps.add(JavaTokenType.OROR);
            booleanOps.add(JavaTokenType.OR);
            shiftOps.add(JavaTokenType.LTLT);
            shiftOps.add(JavaTokenType.GTGT);
            shiftOps.add(JavaTokenType.GTGTGT);
            operatorAssignmentOps.add(JavaTokenType.PLUSEQ);
            operatorAssignmentOps.add(JavaTokenType.MINUSEQ);
            operatorAssignmentOps.add(JavaTokenType.ASTERISKEQ);
            operatorAssignmentOps.add(JavaTokenType.DIVEQ);
            operatorAssignmentOps.add(JavaTokenType.ANDEQ);
            operatorAssignmentOps.add(JavaTokenType.OREQ);
            operatorAssignmentOps.add(JavaTokenType.XOREQ);
            operatorAssignmentOps.add(JavaTokenType.PERCEQ);
            operatorAssignmentOps.add(JavaTokenType.LTLTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTGTEQ);
        }

        private static class TypeStringCreator
        extends PsiTypeVisitor<Object> {
            private final StringBuilder typeString = new StringBuilder();
            private boolean modified = false;

            private TypeStringCreator() {
            }

            public Object visitType(PsiType type) {
                this.typeString.append(type.getCanonicalText());
                return super.visitType(type);
            }

            public Object visitWildcardType(PsiWildcardType wildcardType) {
                PsiClassType classType;
                PsiClass aClass;
                PsiType extendsBound;
                if (wildcardType.isExtends() && (extendsBound = wildcardType.getExtendsBound()) instanceof PsiClassType && (aClass = (classType = (PsiClassType)extendsBound).resolve()) != null && aClass.hasModifierProperty("final")) {
                    this.modified = true;
                    return super.visitClassType(classType);
                }
                return super.visitWildcardType(wildcardType);
            }

            public Object visitClassType(PsiClassType classType) {
                PsiClassType rawType = classType.rawType();
                this.typeString.append(rawType.getCanonicalText());
                PsiType[] parameterTypes = classType.getParameters();
                if (parameterTypes.length > 0) {
                    this.typeString.append('<');
                    PsiType parameterType1 = parameterTypes[0];
                    if (parameterType1 != null) {
                        parameterType1.accept((PsiTypeVisitor)this);
                    }
                    for (int i = 1; i < parameterTypes.length; ++i) {
                        this.typeString.append(',');
                        PsiType parameterType = parameterTypes[i];
                        if (parameterType == null) continue;
                        parameterType.accept((PsiTypeVisitor)this);
                    }
                    this.typeString.append('>');
                }
                return null;
            }

            public String getTypeString() {
                return this.typeString.toString();
            }

            public boolean isModified() {
                return this.modified;
            }
        }
    }
}

