/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerializationMethodsInspectionBase
extends SerializableInspectionBase {
    protected boolean ignoreClassWithoutFields = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (!hasReadObject && !hasWriteObject) {
            String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (hasReadObject) {
            String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor1", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor2", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected JComponent[] createAdditionalOptions() {
        return new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("serializable.has.serialization.methods.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassWithoutFields")};
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if (!"ignoreClassWithoutFields".equals(option.getAttributeValue("name"))) continue;
            this.ignoreClassWithoutFields = Boolean.valueOf(option.getAttributeValue("value"));
        }
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.ignoreClassWithoutFields) {
            node.addContent(new Element("option").setAttribute("name", "ignoreClassWithoutFields").setAttribute("value", String.valueOf(this.ignoreClassWithoutFields)));
        }
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerializationMethodsVisitor();
    }

    private class SerializableHasSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase$SerializableHasSerializationMethodsVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject && hasReadObject) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.ignoreClassWithoutFields) {
                PsiField[] fields = aClass.getFields();
                boolean hasField = false;
                for (PsiField field : fields) {
                    if (field.hasModifierProperty("static")) continue;
                    hasField = true;
                    break;
                }
                if (!hasField) {
                    return;
                }
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }
    }
}

