/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class DemorgansIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return IntentionPowerPackBundle.message("demorgans.intention.name1", new Object[0]);
        }
        return IntentionPowerPackBundle.message("demorgans.intention.name2", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/bool/DemorgansIntention", "getElementPredicate"));
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/bool/DemorgansIntention", "processIntention"));
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element;
        String newExpression = DemorgansIntention.convertConjunctionExpression(polyadicExpression);
        DemorgansIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)polyadicExpression);
    }

    private static String convertConjunctionExpression(PsiPolyadicExpression polyadicExpression) {
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        boolean tokenTypeAndAnd = tokenType.equals(JavaTokenType.ANDAND);
        String flippedConjunction = tokenTypeAndAnd ? "||" : "&&";
        StringBuilder result2 = new StringBuilder();
        for (PsiExpression operand : polyadicExpression.getOperands()) {
            if (result2.length() != 0) {
                result2.append(flippedConjunction);
            }
            result2.append(DemorgansIntention.convertLeafExpression(operand, tokenTypeAndAnd));
        }
        return result2.toString();
    }

    private static String convertLeafExpression(PsiExpression expression, boolean tokenTypeAndAnd) {
        if (BoolUtils.isNegation(expression)) {
            PsiExpression negatedExpression = BoolUtils.getNegated(expression);
            if (negatedExpression == null) {
                return "";
            }
            if (tokenTypeAndAnd ? ParenthesesUtils.getPrecedence(negatedExpression) > 14 : ParenthesesUtils.getPrecedence(negatedExpression) > 13) {
                return '(' + negatedExpression.getText() + ')';
            }
            return negatedExpression.getText();
        }
        if (ComparisonUtils.isComparison(expression)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(expression) > 3) {
            return "!(" + expression.getText() + ')';
        }
        return '!' + expression.getText();
    }
}

