/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.shift.ShiftUtils;

class ShiftByLiteralPredicate
implements PsiElementPredicate {
    ShiftByLiteralPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            return ShiftByLiteralPredicate.isBinaryShiftByLiteral((PsiBinaryExpression)element);
        }
        if (element instanceof PsiAssignmentExpression) {
            return ShiftByLiteralPredicate.isAssignmentShiftByLiteral((PsiAssignmentExpression)element);
        }
        return false;
    }

    private static boolean isAssignmentShiftByLiteral(PsiAssignmentExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.LTLTEQ) && !tokenType.equals(JavaTokenType.GTGTEQ)) {
            return false;
        }
        PsiExpression lhs = expression.getLExpression();
        PsiType lhsType = lhs.getType();
        if (lhsType == null) {
            return false;
        }
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression.getRExpression();
        if (rhs == null) {
            return false;
        }
        return ShiftUtils.isIntLiteral(rhs);
    }

    private static boolean isBinaryShiftByLiteral(PsiBinaryExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.LTLT) && !tokenType.equals(JavaTokenType.GTGT)) {
            return false;
        }
        PsiExpression lOperand = expression.getLOperand();
        PsiType lhsType = lOperand.getType();
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression.getROperand();
        return ShiftUtils.isIntLiteral(rhs);
    }
}

