/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;

public class ImageInfoIndex
extends SingleEntryFileBasedIndexExtension<ImageInfo> {
    private static final int ourMaxImageSize;
    public static final ID<Integer, ImageInfo> INDEX_ID;
    private final DataExternalizer<ImageInfo> myValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(@NotNull DataOutput out, ImageInfo info) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/intellij/images/index/ImageInfoIndex$1", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.width);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.height);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.bpp);
        }

        public ImageInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/intellij/images/index/ImageInfoIndex$1", "read"));
            }
            return new ImageInfo(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in));
        }
    };
    private final SingleEntryIndexer<ImageInfo> myDataIndexer = new SingleEntryIndexer<ImageInfo>(false){

        @Override
        protected ImageInfo computeValue(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/intellij/images/index/ImageInfoIndex$2", "computeValue"));
            }
            ImageInfoReader.Info info = ImageInfoReader.getInfo(inputData.getContent());
            return info != null ? new ImageInfo(info.width, info.height, info.bpp) : null;
        }
    };

    @NotNull
    public ID<Integer, ImageInfo> getName() {
        ID<Integer, ImageInfo> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/index/ImageInfoIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public SingleEntryIndexer<ImageInfo> getIndexer() {
        SingleEntryIndexer<ImageInfo> singleEntryIndexer = this.myDataIndexer;
        if (singleEntryIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/index/ImageInfoIndex", "getIndexer"));
        }
        return singleEntryIndexer;
    }

    public static void processValues(VirtualFile virtualFile, FileBasedIndex.ValueProcessor<ImageInfo> processor2, Project project2) {
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)Math.abs(FileBasedIndex.getFileId((VirtualFile)virtualFile)), virtualFile, processor2, GlobalSearchScope.fileScope((Project)project2, (VirtualFile)virtualFile));
    }

    @NotNull
    public DataExternalizer<ImageInfo> getValueExternalizer() {
        DataExternalizer<ImageInfo> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/index/ImageInfoIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/index/ImageInfoIndex$3", "acceptInput"));
                }
                return file2.isInLocalFileSystem() && file2.getLength() / 1024L < (long)ourMaxImageSize;
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/index/ImageInfoIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public int getVersion() {
        return 5;
    }

    static {
        int maxImageSize = 200;
        try {
            maxImageSize = Integer.parseInt(System.getProperty("idea.max.image.filesize", Integer.toString(maxImageSize)), 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ourMaxImageSize = maxImageSize;
        INDEX_ID = ID.create((String)"ImageFileInfoIndex");
    }

    public static class ImageInfo {
        public int width;
        public int height;
        public int bpp;

        public ImageInfo(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo imageInfo = (ImageInfo)o;
            if (this.bpp != imageInfo.bpp) {
                return false;
            }
            if (this.height != imageInfo.height) {
                return false;
            }
            return this.width == imageInfo.width;
        }

        public int hashCode() {
            int result2 = this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.bpp;
            return result2;
        }
    }
}

