/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import java.awt.Color;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.impl.JDOMExternalizerEx;
import org.jdom.Element;

final class GridOptionsImpl
implements GridOptions,
JDOMExternalizable {
    private boolean showDefault;
    private int lineMinZoomFactor = 3;
    private int lineSpan = 1;
    private Color lineColor = DEFAULT_LINE_COLOR;
    private final PropertyChangeSupport propertyChangeSupport;

    GridOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    @Override
    public boolean isShowDefault() {
        return this.showDefault;
    }

    @Override
    public int getLineZoomFactor() {
        return this.lineMinZoomFactor;
    }

    @Override
    public int getLineSpan() {
        return this.lineSpan;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    void setShowDefault(boolean showDefault) {
        boolean oldValue = this.showDefault;
        if (oldValue != showDefault) {
            this.showDefault = showDefault;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.showDefault", oldValue, this.showDefault);
        }
    }

    void setLineMinZoomFactor(int lineMinZoomFactor) {
        int oldValue = this.lineMinZoomFactor;
        if (oldValue != lineMinZoomFactor) {
            this.lineMinZoomFactor = lineMinZoomFactor;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineZoomFactor", oldValue, this.lineMinZoomFactor);
        }
    }

    void setLineSpan(int lineSpan) {
        int oldValue = this.lineSpan;
        if (oldValue != lineSpan) {
            this.lineSpan = lineSpan;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineSpan", oldValue, this.lineSpan);
        }
    }

    void setLineColor(Color lineColor) {
        Color oldColor = this.lineColor;
        if (lineColor == null) {
            this.lineColor = DEFAULT_LINE_COLOR;
        }
        if (!oldColor.equals(lineColor)) {
            this.lineColor = lineColor;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineColor", oldColor, this.lineColor);
        }
    }

    @Override
    public void inject(GridOptions options) {
        this.setShowDefault(options.isShowDefault());
        this.setLineMinZoomFactor(options.getLineZoomFactor());
        this.setLineSpan(options.getLineSpan());
        this.setLineColor(options.getLineColor());
    }

    @Override
    public boolean setOption(String name, Object value) {
        if ("Editor.Grid.showDefault".equals(name)) {
            this.setShowDefault((Boolean)value);
        } else if ("Editor.Grid.lineZoomFactor".equals(name)) {
            this.setLineMinZoomFactor((Integer)value);
        } else if ("Editor.Grid.lineSpan".equals(name)) {
            this.setLineSpan((Integer)value);
        } else if ("Editor.Grid.lineColor".equals(name)) {
            this.setLineColor((Color)value);
        } else {
            return false;
        }
        return true;
    }

    public void readExternal(Element element) {
        this.showDefault = JDOMExternalizer.readBoolean((Element)element, (String)"Editor.Grid.showDefault");
        this.lineMinZoomFactor = JDOMExternalizer.readInteger((Element)element, (String)"Editor.Grid.lineZoomFactor", (int)3);
        this.lineSpan = JDOMExternalizer.readInteger((Element)element, (String)"Editor.Grid.lineSpan", (int)1);
        this.lineColor = JDOMExternalizerEx.readColor(element, "Editor.Grid.lineColor", DEFAULT_LINE_COLOR);
    }

    public void writeExternal(Element element) {
        JDOMExternalizer.write((Element)element, (String)"Editor.Grid.showDefault", (boolean)this.showDefault);
        JDOMExternalizer.write((Element)element, (String)"Editor.Grid.lineZoomFactor", (int)this.lineMinZoomFactor);
        JDOMExternalizer.write((Element)element, (String)"Editor.Grid.lineSpan", (int)this.lineSpan);
        JDOMExternalizerEx.write(element, "Editor.Grid.lineColor", this.lineColor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GridOptions)) {
            return false;
        }
        GridOptions otherOptions = (GridOptions)obj;
        return this.lineMinZoomFactor == otherOptions.getLineZoomFactor() && this.lineSpan == otherOptions.getLineSpan() && this.showDefault == otherOptions.isShowDefault() && this.lineColor != null ? this.lineColor.equals(otherOptions.getLineColor()) : otherOptions.getLineColor() == null;
    }

    public int hashCode() {
        int result2 = this.showDefault ? 1 : 0;
        result2 = 29 * result2 + this.lineMinZoomFactor;
        result2 = 29 * result2 + this.lineSpan;
        result2 = 29 * result2 + (this.lineColor != null ? this.lineColor.hashCode() : 0);
        return result2;
    }
}

