/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

class RemoveRedundantEscapeAction
implements IntentionAction {
    private final RegExpChar myChar;

    RemoveRedundantEscapeAction(@NotNull RegExpChar ch) {
        if (ch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ch", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "<init>"));
        }
        this.myChar = ch;
    }

    @NotNull
    public String getText() {
        if ("Remove redundant escape" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "getText"));
        }
        return "Remove redundant escape";
    }

    @NotNull
    public String getFamilyName() {
        if ("Redundant character escape" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "getFamilyName"));
        }
        return "Redundant character escape";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "isAvailable"));
        }
        return this.myChar.isValid() && this.myChar.getUnescapedText().startsWith("\\");
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        Character v = this.myChar.getValue();
        assert (v != null);
        ASTNode node = this.myChar.getNode().getFirstChildNode();
        ASTNode parent = node.getTreeParent();
        parent.addLeaf(RegExpTT.CHARACTER, (CharSequence)this.replacement(v), node);
        parent.removeChild(node);
    }

    @NotNull
    private String replacement(@NotNull Character v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "replacement"));
        }
        PsiElement context = this.myChar.getContainingFile().getContext();
        String string = RegExpElementImpl.isLiteralExpression(context) ? StringUtil.escapeStringCharacters((String)v.toString()) : (context instanceof XmlElement ? XmlStringUtil.escapeString((String)v.toString()) : v.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "replacement"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

