/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PatternFilter;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;

public class RncCompletionData
extends CompletionData {
    public RncCompletionData() {
        this.declareFinalScope(RncElement.class);
        CompletionVariant variant = new CompletionVariant(new AndFilter(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return true;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return PsiElement.class.isAssignableFrom(hintClass);
            }
        }, (ElementFilter)new PatternFilter(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RncTokenTypes.KEYWORD_DEFAULT)), StandardPatterns.not((ElementPattern)StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement((IElementType)RncTokenTypes.LITERAL)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(RncTokenTypes.KEYWORDS))}))}))));
        variant.includeScopeClass(LeafPsiElement.class, true);
        variant.addCompletion(new KeywordGetter());
        this.registerVariant(variant);
    }

    private static class KeywordGetter
    implements ContextGetter {
        private static final ElementPattern TOP_LEVEL = StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(RncGrammar.class).inside(true, (ElementPattern)PlatformPatterns.psiElement(RncGrammar.class))));
        private static final PsiElementPattern DECL_PATTERN = (PsiElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(RncDecl.class));
        private static final PsiElementPattern DEFAULT_PATTERN = DECL_PATTERN.afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("default"));
        private static final ElementPattern DEFINE_PATTERN = StandardPatterns.and((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(RncDefine.class), PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PlatformPatterns.psiElement().withText("="))});
        private static final String[] DECL_KEYWORDS = new String[]{"default", "namespace", "datatypes"};
        private static final String[] GRAMMAR_CONTENT_KEYWORDS = new String[]{"include", "div", "start"};
        private static final String[] PATTERN_KEYWORDS = new String[]{"attribute", "element", "grammar", "notAllowed", "text", "empty", "external", "parent", "list", "mixed"};

        private KeywordGetter() {
        }

        @Override
        public Object[] get(PsiElement context, CompletionContext completionContext) {
            return ContainerUtil.map2Array((Object[])this.doGetKeywords(context), LookupElement.class, s -> TailTypeDecorator.withTail(LookupElementBuilder.create((String)s).bold(), TailType.SPACE));
        }

        private String[] doGetKeywords(PsiElement context) {
            PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)context, (Class[])new Class[]{PsiWhiteSpace.class});
            if (next != null && EscapeUtil.unescapeText(next).equals("=")) {
                return new String[]{"start"};
            }
            if (DEFAULT_PATTERN.accepts((Object)context)) {
                return new String[]{"namespace"};
            }
            if (DECL_PATTERN.accepts((Object)context)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (context.getParent() instanceof RncDefine && context.getParent().getFirstChild() == context) {
                if (DEFINE_PATTERN.accepts((Object)context)) {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                if (TOP_LEVEL.accepts((Object)context) && !this.afterPattern(context)) {
                    return ArrayUtil.mergeArrays((String[])DECL_KEYWORDS, (String[])ArrayUtil.mergeArrays((String[])GRAMMAR_CONTENT_KEYWORDS, (String[])PATTERN_KEYWORDS));
                }
                return GRAMMAR_CONTENT_KEYWORDS;
            }
            return PATTERN_KEYWORDS;
        }

        private boolean afterPattern(PsiElement context) {
            return PsiTreeUtil.getPrevSiblingOfType((PsiElement)context.getParent(), RncDefine.class) != null;
        }
    }
}

