/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\u001c\u001a\u0004\u0018\u00010\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&J>\u0010*\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMap;", "", "outFile", "", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceIndexToMappings", "", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "hasNameMappings", "", "(Ljava/lang/String;Lorg/jetbrains/debugger/sourcemap/MappingList;[Lorg/jetbrains/debugger/sourcemap/MappingList;Lorg/jetbrains/debugger/sourcemap/SourceResolver;Z)V", "getHasNameMappings", "()Z", "getMappings", "()Lorg/jetbrains/debugger/sourcemap/MappingList;", "getOutFile", "()Ljava/lang/String;", "getSourceIndexToMappings$script_debugger_backend", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "[Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findMappingList", "sourceUrls", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lcom/intellij/openapi/util/NullableLazyValue;", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "getMappingsOrderedBySource", "source", "", "getSourceLineByRawLocation", "rawLine", "rawColumn", "processMappingsInLine", "sourceLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingList$MappingsProcessorInLine;", "script-debugger-backend"})
public final class SourceMap {
    @Nullable
    private final String outFile;
    @NotNull
    private final MappingList mappings;
    @NotNull
    private final MappingList[] sourceIndexToMappings;
    @NotNull
    private final SourceResolver sourceResolver;
    private final boolean hasNameMappings;

    @NotNull
    public final Url[] getSources() {
        return this.sourceResolver.getCanonicalizedUrls$script_debugger_backend();
    }

    public final int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        MappingEntry mappingEntry = this.mappings.get(rawLine, rawColumn);
        return mappingEntry != null ? mappingEntry.getSourceLine() : -1;
    }

    @Nullable
    public final MappingList findMappingList(@NotNull List<? extends Url> sourceUrls, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        MappingList mappings = this.sourceResolver.findMappings(sourceUrls, this, sourceFile);
        if (mappings == null && resolver != null) {
            MappingList mappingList;
            SourceResolver.Resolver resolver2 = (SourceResolver.Resolver)resolver.getValue();
            if (resolver2 != null) {
                SourceResolver.Resolver it;
                SourceResolver.Resolver resolver3 = resolver2;
                SourceResolver.Resolver resolver4 = it = resolver3;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolver4, (String)"it");
                mappingList = this.sourceResolver.findMappings(sourceFile, this, resolver4);
            } else {
                mappingList = null;
            }
            mappings = mappingList;
        }
        return mappings;
    }

    public final boolean processMappingsInLine(@NotNull List<? extends Url> sourceUrls, int sourceLine, @NotNull MappingList.MappingsProcessorInLine mappingProcessor, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)mappingProcessor, (String)"mappingProcessor");
        MappingList mappings = this.findMappingList(sourceUrls, sourceFile, resolver);
        return mappings != null && mappings.processMappingsInLine(sourceLine, mappingProcessor);
    }

    @NotNull
    public final MappingList getMappingsOrderedBySource(int source) {
        MappingList mappingList = this.sourceIndexToMappings[source];
        if (mappingList == null) {
            Intrinsics.throwNpe();
        }
        return mappingList;
    }

    @Nullable
    public final String getOutFile() {
        return this.outFile;
    }

    @NotNull
    public final MappingList getMappings() {
        return this.mappings;
    }

    @NotNull
    public final MappingList[] getSourceIndexToMappings$script_debugger_backend() {
        return this.sourceIndexToMappings;
    }

    @NotNull
    public final SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public final boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    public SourceMap(@Nullable String outFile, @NotNull MappingList mappings, @NotNull MappingList[] sourceIndexToMappings, @NotNull SourceResolver sourceResolver, boolean hasNameMappings) {
        Intrinsics.checkParameterIsNotNull((Object)mappings, (String)"mappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceIndexToMappings, (String)"sourceIndexToMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceResolver, (String)"sourceResolver");
        this.outFile = outFile;
        this.mappings = mappings;
        this.sourceIndexToMappings = sourceIndexToMappings;
        this.sourceResolver = sourceResolver;
        this.hasNameMappings = hasNameMappings;
    }
}

