/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u00020\u0001*\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"decodeString", "", "decoder", "Ljava/nio/charset/CharsetDecoder;", "src", "Ljava/nio/ByteBuffer;", "dst", "Ljava/nio/CharBuffer;", "writeIntAsAscii", "value", "", "buffer", "Lio/netty/buffer/ByteBuf;", "readIntoCharBuffer", "byteCount", "charBuffer", "platform-impl"})
public final class BufferToCharsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readIntoCharBuffer(@NotNull ByteBuf $receiver, int byteCount, @NotNull CharBuffer charBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charBuffer, (String)"charBuffer");
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)CharsetUtil.UTF_8);
        if ($receiver.nioBufferCount() == 1) {
            CharsetDecoder charsetDecoder = decoder;
            Intrinsics.checkExpressionValueIsNotNull((Object)charsetDecoder, (String)"decoder");
            ByteBuffer byteBuffer = $receiver.internalNioBuffer($receiver.readerIndex(), byteCount);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"internalNioBuffer(readerIndex(), byteCount)");
            BufferToCharsKt.decodeString(charsetDecoder, byteBuffer, charBuffer);
        } else {
            ByteBuf buffer = $receiver.alloc().heapBuffer(byteCount);
            try {
                buffer.writeBytes($receiver, $receiver.readerIndex(), byteCount);
                CharsetDecoder charsetDecoder = decoder;
                Intrinsics.checkExpressionValueIsNotNull((Object)charsetDecoder, (String)"decoder");
                ByteBuffer byteBuffer = buffer.internalNioBuffer(0, byteCount);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer.internalNioBuffer(0, byteCount)");
                BufferToCharsKt.decodeString(charsetDecoder, byteBuffer, charBuffer);
            }
            finally {
                buffer.release();
            }
        }
    }

    public static /* bridge */ /* synthetic */ void readIntoCharBuffer$default(ByteBuf byteBuf, int n, CharBuffer charBuffer, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readIntoCharBuffer");
        }
        if ((n2 & 1) != 0) {
            n = byteBuf.readableBytes();
        }
        BufferToCharsKt.readIntoCharBuffer(byteBuf, n, charBuffer);
    }

    private static final void decodeString(CharsetDecoder decoder, ByteBuffer src, CharBuffer dst) {
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw (Throwable)new IllegalStateException(x);
        }
    }

    public static final void writeIntAsAscii(int value, @NotNull ByteBuf buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)new StringBuilder().append(value));
    }
}

