/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;

@ChannelHandler.Sharable
final class MessageChannelHandler
extends WebSocketProtocolHandler {
    private final ClientManager clientManager;
    private final MessageServer messageServer;

    MessageChannelHandler(@NotNull ClientManager clientManager, @NotNull MessageServer messageServer) {
        if (clientManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientManager", "org/jetbrains/io/webSocket/MessageChannelHandler", "<init>"));
        }
        if (messageServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageServer", "org/jetbrains/io/webSocket/MessageChannelHandler", "<init>"));
        }
        this.clientManager = clientManager;
        this.messageServer = messageServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeFrameReceived(@NotNull Channel channel, @NotNull CloseWebSocketFrame message) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/webSocket/MessageChannelHandler", "closeFrameReceived"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/webSocket/MessageChannelHandler", "closeFrameReceived"));
        }
        WebSocketClient client = (WebSocketClient)((Object)channel.attr(ClientManagerKt.getCLIENT()).get());
        if (client == null) {
            super.closeFrameReceived(channel, message);
        } else {
            try {
                this.clientManager.disconnectClient(channel, client, false);
            }
            finally {
                client.disconnect(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void textFrameReceived(@NotNull Channel channel, @NotNull TextWebSocketFrame message) {
        String chars;
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/webSocket/MessageChannelHandler", "textFrameReceived"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/webSocket/MessageChannelHandler", "textFrameReceived"));
        }
        WebSocketClient client = (WebSocketClient)((Object)channel.attr(ClientManagerKt.getCLIENT()).get());
        try {
            chars = NettyKt.readUtf8(message.content());
        }
        catch (Throwable e) {
            try {
                message.release();
            }
            finally {
                this.clientManager.getExceptionHandler().exceptionCaught(e);
            }
            return;
        }
        try {
            this.messageServer.messageReceived(client, chars);
        }
        catch (Throwable e) {
            this.clientManager.getExceptionHandler().exceptionCaught(e);
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Client client = (Client)((Object)context.channel().attr(ClientManagerKt.getCLIENT()).get());
        if (client != null) {
            this.clientManager.disconnectClient(context.channel(), client, false);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/webSocket/MessageChannelHandler", "exceptionCaught"));
        }
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/io/webSocket/MessageChannelHandler", "exceptionCaught"));
        }
        try {
            this.clientManager.getExceptionHandler().exceptionCaught(cause);
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

