/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesFilesSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element) {
        return element instanceof PropertiesFile;
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "findUsages"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "findUsages"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "findUsages"));
        }
        PropertiesFile file = (PropertiesFile)element;
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(file.getContainingFile());
        for (IProperty iProperty : file.getProperties()) {
            elements.add(iProperty.getPsiElement());
        }
        for (PsiElement psiElement : elements) {
            SafeDeleteProcessor.findGenericElementUsages((PsiElement)psiElement, result, (PsiElement[])allElementsToDelete);
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), elements);
    }

    public Collection<PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "getElementsToSearch"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "getElementsToSearch"));
        }
        return Collections.singletonList(element);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        return null;
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "findConflicts"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/properties/refactoring/PropertiesFilesSafeDeleteProcessor", "findConflicts"));
        }
        return null;
    }

    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

