/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.MathUtil;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class FloatSubject
extends ComparableSubject<FloatSubject, Float> {
    private static final int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);

    FloatSubject(FailureStrategy failureStrategy, @Nullable Float subject) {
        super(failureStrategy, subject);
    }

    public TolerantFloatComparison isWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.getSubject();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object[])new Object[]{Float.valueOf(tolerance), Float.valueOf(expected)});
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.equals(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithRawMessage("%s and <%s> should have been finite values within <%s> of each other", FloatSubject.this.getDisplaySubject(), Float.valueOf(expected), Float.valueOf(tolerance));
                }
            }
        };
    }

    public TolerantFloatComparison isNotWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.getSubject();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object[])new Object[]{Float.valueOf(tolerance), Float.valueOf(expected)});
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.notEquals(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithRawMessage("%s and <%s> should have been finite values not within <%s> of each other", FloatSubject.this.getDisplaySubject(), Float.valueOf(expected), Float.valueOf(tolerance));
                }
            }
        };
    }

    @Deprecated
    public final void isEqualTo(@Nullable Float other) {
        super.isEqualTo(other);
    }

    @Deprecated
    public final void isNotEqualTo(@Nullable Float other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Float other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(float tolerance) {
        Preconditions.checkArgument((!Float.isNaN(tolerance) ? 1 : 0) != 0, (Object)"tolerance cannot be NaN");
        Preconditions.checkArgument((tolerance >= 0.0f ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object[])new Object[]{Float.valueOf(tolerance)});
        Preconditions.checkArgument((Float.floatToIntBits(tolerance) != NEG_ZERO_BITS ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object[])new Object[]{Float.valueOf(tolerance)});
        Preconditions.checkArgument((tolerance != Float.POSITIVE_INFINITY ? 1 : 0) != 0, (Object)"tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isPositiveInfinity() {
        super.isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public final void isNegativeInfinity() {
        super.isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    public final void isNaN() {
        super.isEqualTo(Float.valueOf(Float.NaN));
    }

    public final void isFinite() {
        if (this.getSubject() == null || ((Float)this.getSubject()).isNaN() || ((Float)this.getSubject()).isInfinite()) {
            this.failWithRawMessage("%s should have been finite", this.getDisplaySubject());
        }
    }

    public final void isNotNaN() {
        if (this.getSubject() == null || ((Float)this.getSubject()).isNaN()) {
            this.failWithRawMessage("%s should not have been NaN", this.getDisplaySubject());
        }
    }

    public abstract class TolerantFloatComparison {
        private TolerantFloatComparison() {
        }

        public abstract void of(float var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare floats, use .of(float) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

