/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ParsingProcessOutputHandler
extends BaseProcessOutputHandler {
    private final ToolOutputParser mErrorToolOutputParser;
    private final ToolOutputParser mStdoutToolOutputParser;
    private final List<MessageReceiver> mMessageReceivers;

    public ParsingProcessOutputHandler(ToolOutputParser errorToolOutputParser, ToolOutputParser stdoutToolOutputParser, MessageReceiver ... messageReceivers) {
        this.mErrorToolOutputParser = errorToolOutputParser;
        this.mStdoutToolOutputParser = stdoutToolOutputParser;
        this.mMessageReceivers = ImmutableList.copyOf((Object[])messageReceivers);
    }

    public ParsingProcessOutputHandler(ToolOutputParser toolOutputParser, MessageReceiver ... messageReceivers) {
        this(toolOutputParser, toolOutputParser, messageReceivers);
    }

    @Override
    public void handleOutput(ProcessOutput processOutput) throws ProcessException {
        String stderr;
        if (!(processOutput instanceof BaseProcessOutputHandler.BaseProcessOutput)) {
            throw new IllegalArgumentException("processOutput was not created by this handler.");
        }
        BaseProcessOutputHandler.BaseProcessOutput impl = (BaseProcessOutputHandler.BaseProcessOutput)processOutput;
        String stdout = impl.getStandardOutputAsString();
        if (!stdout.isEmpty()) {
            this.outputMessages(this.mStdoutToolOutputParser.parseToolOutput(stdout));
        }
        if (!(stderr = impl.getErrorOutputAsString()).isEmpty()) {
            this.outputMessages(this.mErrorToolOutputParser.parseToolOutput(stderr));
        }
    }

    private void outputMessages(List<Message> messages) {
        for (Message message : messages) {
            for (MessageReceiver messageReceiver : this.mMessageReceivers) {
                messageReceiver.receiveMessage(message);
            }
        }
    }
}

