/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNRangeTree {
    private SVNRangeTreeNode myRoot = null;
    private SVNRangeTreeNode myFreeTreeNodes;
    private SVNRangeTreeNode myAllocatedTreeNodes;
    private SVNRangeListNode myFreeListNodes;
    private SVNRangeTreeNode myScratchNode = new SVNRangeTreeNode(0, 0, 0);

    private SVNRangeTreeNode allocateTreeNode(int offset, int limit, int target) {
        if (this.myFreeTreeNodes == null) {
            SVNRangeTreeNode node = new SVNRangeTreeNode(offset, limit, target);
            node.nextFree = this.myAllocatedTreeNodes;
            this.myAllocatedTreeNodes = node;
            return node;
        }
        SVNRangeTreeNode node = this.myFreeTreeNodes;
        this.myFreeTreeNodes = node.nextFree;
        node.prev = null;
        node.next = null;
        node.right = null;
        node.left = null;
        node.offset = offset;
        node.limit = limit;
        node.targetOffset = target;
        node.nextFree = this.myAllocatedTreeNodes;
        this.myAllocatedTreeNodes = node;
        return node;
    }

    private void freeTreeNode(SVNRangeTreeNode node) {
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        node.next = null;
        node.prev = null;
        node.left = null;
        node.right = null;
        if (this.myAllocatedTreeNodes == node) {
            this.myAllocatedTreeNodes = this.myAllocatedTreeNodes.nextFree;
        } else {
            SVNRangeTreeNode allocated = this.myAllocatedTreeNodes;
            while (allocated.nextFree != node) {
                allocated = allocated.nextFree;
            }
            allocated.nextFree = node.nextFree;
        }
        node.nextFree = this.myFreeTreeNodes;
        this.myFreeTreeNodes = node;
    }

    private SVNRangeListNode allocateListNode(int kind, int offset, int limit, int target) {
        if (this.myFreeListNodes == null) {
            return new SVNRangeListNode(kind, offset, limit, target);
        }
        SVNRangeListNode node = this.myFreeListNodes;
        this.myFreeListNodes = node.next;
        node.offset = offset;
        node.limit = limit;
        node.targetOffset = target;
        node.kind = kind;
        node.next = null;
        node.prev = null;
        node.head = node;
        return node;
    }

    public void disposeList(SVNRangeListNode head) {
        SVNRangeListNode n = head;
        while (head.next != null) {
            head = head.next;
        }
        head.next = this.myFreeListNodes;
        this.myFreeListNodes = n;
    }

    public void dispose() {
        SVNRangeTreeNode node = this.myFreeTreeNodes;
        if (node == null) {
            this.myFreeTreeNodes = this.myAllocatedTreeNodes;
        } else {
            while (node.nextFree != null) {
                node = node.nextFree;
            }
            node.nextFree = this.myAllocatedTreeNodes;
        }
        this.myAllocatedTreeNodes = null;
        this.myRoot = null;
    }

    public SVNRangeListNode buildRangeList(int offset, int limit) throws SVNException {
        SVNRangeListNode tail = null;
        SVNRangeTreeNode node = this.myRoot;
        while (offset < limit) {
            if (node == null) {
                return this.appendToRangeList(SVNRangeListNode.FROM_SOURCE, offset, limit, 0, tail);
            }
            if (offset < node.offset) {
                if (limit <= node.offset) {
                    return this.appendToRangeList(SVNRangeListNode.FROM_SOURCE, offset, limit, 0, tail);
                }
                tail = this.appendToRangeList(SVNRangeListNode.FROM_SOURCE, offset, node.offset, 0, tail);
                offset = node.offset;
                continue;
            }
            if (offset >= node.limit) {
                node = node.next;
                continue;
            }
            int targetOffset = offset - node.offset + node.targetOffset;
            if (limit <= node.limit) {
                return this.appendToRangeList(SVNRangeListNode.FROM_TARGET, offset, limit, targetOffset, tail);
            }
            tail = this.appendToRangeList(SVNRangeListNode.FROM_TARGET, offset, node.limit, targetOffset, tail);
            offset = node.limit;
            node = node.next;
        }
        SVNErrorManager.assertionFailure(false, null, SVNLogType.DEFAULT);
        return tail;
    }

    private SVNRangeListNode appendToRangeList(int kind, int offset, int limit, int tOffset, SVNRangeListNode tail) {
        if (tail == null) {
            return this.allocateListNode(kind, offset, limit, tOffset);
        }
        return tail.append(this.allocateListNode(kind, offset, limit, tOffset));
    }

    public void splay(int offset) throws SVNException {
        SVNRangeTreeNode node;
        if (this.myRoot == null) {
            return;
        }
        SVNRangeTreeNode root = this.myRoot;
        SVNRangeTreeNode scratch = this.myScratchNode;
        scratch.right = null;
        scratch.left = null;
        SVNRangeTreeNode left = scratch;
        SVNRangeTreeNode right = scratch;
        while (true) {
            if (offset < root.offset) {
                if (root.left != null && offset < root.left.offset) {
                    node = root.left;
                    root.left = node.right;
                    node.right = root;
                    root = node;
                }
                if (root.left == null) break;
                right.left = root;
                right = root;
                root = root.left;
                continue;
            }
            if (offset <= root.offset) break;
            if (root.right != null && offset > root.right.offset) {
                node = root.right;
                root.right = node.left;
                node.left = root;
                root = node;
            }
            if (root.right == null) break;
            left.right = root;
            left = root;
            root = root.right;
        }
        left.right = root.left;
        right.left = root.right;
        root.left = scratch.right;
        root.right = scratch.left;
        if (offset < root.offset && root.left != null) {
            if (root.left.right == null) {
                node = root.left;
                root.left = node.right;
                SVNErrorManager.assertionFailure(root.left == null, null, SVNLogType.DEFAULT);
                node.right = root;
                root = node;
            } else {
                SVNRangeTreeNode nodePointer = root.left;
                SVNRangeTreeNode nodeOwner = root;
                boolean isLeft = true;
                while (nodePointer.right != null) {
                    nodeOwner = nodePointer;
                    nodePointer = nodePointer.right;
                    isLeft = false;
                }
                right = root;
                left = root.left;
                root = nodePointer;
                if (isLeft) {
                    nodeOwner.left = root.left;
                } else {
                    nodeOwner.right = root.left;
                }
                SVNErrorManager.assertionFailure(root.right == null, null, SVNLogType.DEFAULT);
                right.left = root.right;
                root.left = left;
                root.right = right;
            }
        }
        this.myRoot = root;
        SVNErrorManager.assertionFailure(offset >= root.offset || root.left == null && root.prev == null, null, SVNLogType.DEFAULT);
    }

    public void insert(int offset, int limit, int targetOffset) throws SVNException {
        if (this.myRoot == null) {
            this.myRoot = this.allocateTreeNode(offset, limit, targetOffset);
            return;
        }
        if (offset == this.myRoot.offset && limit > this.myRoot.limit) {
            this.myRoot.limit = limit;
            this.myRoot.targetOffset = targetOffset;
            this.cleanTree(limit);
        } else if (offset > this.myRoot.offset && limit > this.myRoot.limit) {
            boolean haveToInsertRange;
            boolean bl = haveToInsertRange = this.myRoot.next == null || this.myRoot.limit < this.myRoot.next.offset || limit > this.myRoot.next.limit;
            if (haveToInsertRange) {
                if (this.myRoot.prev != null && this.myRoot.prev.limit > offset) {
                    this.myRoot.offset = offset;
                    this.myRoot.limit = limit;
                    this.myRoot.targetOffset = targetOffset;
                } else {
                    SVNRangeTreeNode node = this.allocateTreeNode(offset, limit, targetOffset);
                    node.next = this.myRoot.next;
                    if (node.next != null) {
                        node.next.prev = node;
                    }
                    this.myRoot.next = node;
                    node.prev = this.myRoot;
                    node.right = this.myRoot.right;
                    this.myRoot.right = null;
                    node.left = this.myRoot;
                    this.myRoot = node;
                }
                this.cleanTree(limit);
            }
        } else if (offset < this.myRoot.offset) {
            SVNErrorManager.assertionFailure(this.myRoot.left == null, null, SVNLogType.DEFAULT);
            SVNRangeTreeNode node = this.allocateTreeNode(offset, limit, targetOffset);
            node.prev = null;
            node.left = null;
            node.right = node.next = this.myRoot;
            this.myRoot = node.next.prev = node;
            this.cleanTree(limit);
        }
    }

    private void cleanTree(int limit) {
        int topOffset = limit + 1;
        SVNRangeTreeNode rightNode = this.myRoot.right;
        SVNRangeTreeNode owner = this.myRoot;
        if (rightNode == null) {
            return;
        }
        boolean left = false;
        while (rightNode != null) {
            int offset;
            int n = offset = rightNode.right != null && rightNode.right.offset < topOffset ? rightNode.offset : topOffset;
            if (rightNode.limit <= limit || rightNode.offset < limit && offset < limit) {
                SVNRangeTreeNode rightRight = rightNode.right;
                rightNode.right = null;
                if (left) {
                    owner.left = rightRight;
                } else {
                    owner.right = rightRight;
                }
                this.deleteSubtree(rightNode);
                rightNode = left ? owner.left : owner.right;
                continue;
            }
            topOffset = rightNode.offset;
            owner = rightNode;
            rightNode = rightNode.left;
            left = true;
        }
    }

    private void deleteSubtree(SVNRangeTreeNode node) {
        if (node != null) {
            this.deleteSubtree(node.left);
            this.deleteSubtree(node.right);
            this.freeTreeNode(node);
        }
    }

    public static class SVNRangeListNode {
        public static int FROM_SOURCE = 0;
        public static int FROM_TARGET = 1;
        public int kind;
        public int offset;
        public int limit;
        public int targetOffset;
        public SVNRangeListNode prev;
        public SVNRangeListNode next;
        public SVNRangeListNode head;

        public SVNRangeListNode(int kind, int offset, int limit, int target) {
            this.kind = kind;
            this.offset = offset;
            this.limit = limit;
            this.targetOffset = target;
            this.head = this;
        }

        public SVNRangeListNode append(SVNRangeListNode node) {
            this.next = node;
            node.prev = this;
            node.head = this.head;
            return node;
        }
    }

    public static class SVNRangeTreeNode {
        public int offset;
        public int limit;
        public int targetOffset;
        public SVNRangeTreeNode left;
        public SVNRangeTreeNode right;
        public SVNRangeTreeNode prev;
        public SVNRangeTreeNode next;
        public SVNRangeTreeNode nextFree;

        public SVNRangeTreeNode(int offset, int limit, int target) {
            this.offset = offset;
            this.limit = limit;
            this.targetOffset = target;
        }

        public String toString() {
            String str = this.offset + ":" + this.limit + ":" + this.targetOffset;
            return str;
        }
    }
}

