/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.checks.ApiLookup;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UTypeReference;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastVariableKind;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.java.JavaUType;
import org.jetbrains.uast.java.JavaUVariable;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/klint/checks/ApiDetector;", "Lcom/android/tools/klint/detector/api/Detector;", "Lorg/jetbrains/uast/check/UastScanner;", "()V", "mApiDatabase", "Lcom/android/tools/klint/checks/ApiLookup;", "getMApiDatabase", "()Lcom/android/tools/klint/checks/ApiLookup;", "setMApiDatabase", "(Lcom/android/tools/klint/checks/ApiLookup;)V", "mWarnedMissingDb", "", "beforeCheckProject", "", "context", "Lcom/android/tools/klint/detector/api/Context;", "createUastVisitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "Lorg/jetbrains/uast/check/UastAndroidContext;", "getSpeed", "Lcom/android/tools/klint/detector/api/Speed;", "ApiVersionVisitor", "Companion", "lint-checks"})
public class ApiDetector
extends Detector
implements UastScanner {
    @Nullable
    private ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private static final boolean AOSP_BUILD;
    private static final String SDK_INT_CONTAINING = "android.os.Build.VERSION";
    private static final String SDK_INT = "SDK_INT";
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED;
    @JvmField
    @NotNull
    public static final Issue INLINED;
    @JvmField
    @NotNull
    public static final Issue OVERRIDE;
    public static final Companion Companion;

    @Nullable
    protected final ApiLookup getMApiDatabase() {
        return this.mApiDatabase;
    }

    protected final void setMApiDatabase(@Nullable ApiLookup apiLookup) {
        this.mApiDatabase = apiLookup;
    }

    @Override
    @NonNull
    @NotNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public void beforeCheckProject(@NonNull @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mApiDatabase = ApiLookup.get(context.getClient());
        if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
            this.mWarnedMissingDb = true;
            context.report(IssueRegistry.LINT_ERROR, Location.create(context.file), "Can't find API database; API check not performed");
        }
    }

    @Override
    @NotNull
    public UastVisitor createUastVisitor(@NotNull UastAndroidContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new ApiVersionVisitor(context);
    }

    static {
        Companion = new Companion(null);
        AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
        SDK_INT_CONTAINING = SDK_INT_CONTAINING;
        SDK_INT = SDK_INT;
        UNSUPPORTED = Issue.create("NewApi", "Calling new methods on older versions", "This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\n\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-vNN` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, Scope.SOURCE_FILE_SCOPE));
        INLINED = Issue.create("InlinedApi", "Using inlined constants on older versions", "This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.SOURCE_FILE_SCOPE));
        OVERRIDE = Issue.create("Override", "Method conflicts with new inherited method", "Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, Scope.SOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/klint/checks/ApiDetector$ApiVersionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lorg/jetbrains/uast/check/UastAndroidContext;", "(Lcom/android/tools/klint/checks/ApiDetector;Lorg/jetbrains/uast/check/UastAndroidContext;)V", "getContext", "()Lorg/jetbrains/uast/check/UastAndroidContext;", "mMinApi", "", "checkIfSpecialCase", "", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "owner", "Lorg/jetbrains/uast/UClass;", "checkVersion", "", "node", "Lorg/jetbrains/uast/UElement;", "getMinSdk", "getSupertypeFromAndroidSdk", "Lorg/jetbrains/uast/UastContext;", "clazz", "isSdkClass", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitFunction", "Lorg/jetbrains/uast/UFunction;", "visitSimpleReferenceExpression", "Lorg/jetbrains/uast/USimpleReferenceExpression;", "lint-checks"})
    private final class ApiVersionVisitor
    extends AbstractUastVisitor {
        private int mMinApi;
        @NotNull
        private final UastAndroidContext context;

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UastCallKind uastCallKind = node.getKind();
            if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.FUNCTION_CALL)) {
                USimpleReferenceExpression uSimpleReferenceExpression = node.getFunctionReference();
                this.checkVersion(this.context, node, uSimpleReferenceExpression != null ? uSimpleReferenceExpression.resolve(this.context) : null);
            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                USimpleReferenceExpression uSimpleReferenceExpression = node.getClassReference();
                this.checkVersion(this.context, node, uSimpleReferenceExpression != null ? uSimpleReferenceExpression.resolve(this.context) : null);
            }
            return super.visitCallExpression(node);
        }

        @Override
        public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UTypeReference typeRef = node.getTypeReference();
            if (typeRef != null) {
                this.checkVersion(this.context, typeRef, node.getType().resolve(this.context));
            }
            return super.visitBinaryExpressionWithType(node);
        }

        @Override
        public boolean visitSimpleReferenceExpression(@NotNull USimpleReferenceExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UElement uElement = node;
            UDeclaration uDeclaration = node.resolve(this.context);
            if (!(uDeclaration instanceof UVariable)) {
                uDeclaration = null;
            }
            this.checkVersion(this.context, uElement, (UVariable)uDeclaration);
            return super.visitSimpleReferenceExpression(node);
        }

        @Override
        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UElement nameElement2 = node.getNameElement();
            if (nameElement2 != null) {
                for (UType type2 : node.getSuperTypes()) {
                    this.checkVersion(this.context, nameElement2, type2.resolveClass(this.context));
                }
            }
            return super.visitClass(node);
        }

        @Override
        public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UClass clazz = node.getType().resolve(this.context);
            if (clazz != null) {
                this.checkVersion(this.context, node, clazz);
            }
            return super.visitClassLiteralExpression(node);
        }

        @Override
        public boolean visitFunction(@NotNull UFunction node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (!node.hasModifier(UastModifier.OVERRIDE)) {
                UElement uElement = node.getParent();
                if (!(uElement instanceof UClass)) {
                    uElement = null;
                }
                UClass uClass = (UClass)uElement;
                if (uClass == null) {
                    return false;
                }
                UClass parentClass = uClass;
                ApiLookup apiLookup = ApiDetector.this.getMApiDatabase();
                if (apiLookup == null) {
                    return false;
                }
                ApiLookup db = apiLookup;
                String string = node.getBytecodeDescriptor();
                if (string == null) {
                    return false;
                }
                String desc = string;
                int buildSdk = this.context.getLintContext().getMainProject().getBuildSdk();
                if (buildSdk == -1) {
                    return false;
                }
                for (UType type2 : parentClass.getSuperTypes()) {
                    String internalName2;
                    UClass clazz;
                    if (type2.resolve(this.context) == null) {
                        continue;
                    }
                    if (!this.isSdkClass(clazz)) continue;
                    if (clazz.getInternalName() == null) {
                        continue;
                    }
                    int methodSdkLevel = db.getCallVersion(internalName2, node.getName(), desc);
                    if (methodSdkLevel == -1 || methodSdkLevel <= buildSdk) continue;
                    String message2 = "This method is not overriding anything with the current build " + ("target, but will in API level " + methodSdkLevel + " (current target is " + buildSdk + "): `" + node.getName() + "`");
                    Issue issue = OVERRIDE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"OVERRIDE");
                    this.context.report(issue, node, this.context.getLocation(node.getNameElement()), message2);
                }
            }
            return false;
        }

        private final boolean checkIfSpecialCase(UDeclaration declaration2, UClass owner) {
            if (declaration2 instanceof UVariable && Intrinsics.areEqual((Object)owner.getFqName(), (Object)"android.os.Build.VERSION_CODES")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)declaration2.getName(), (Object)"MATCH_PARENT") && Intrinsics.areEqual((Object)owner.getFqName(), (Object)"android.view.ViewGroup.LayoutParams")) {
                return true;
            }
            if ((Intrinsics.areEqual((Object)declaration2.getName(), (Object)"CHOICE_MODE_NONE") || Intrinsics.areEqual((Object)declaration2.getName(), (Object)"CHOICE_MODE_MULTIPLE") || Intrinsics.areEqual((Object)declaration2.getName(), (Object)"CHOICE_MODE_SINGLE")) && Intrinsics.areEqual((Object)owner.getFqName(), (Object)"android.widget.AbsListView")) {
                return true;
            }
            return (Intrinsics.areEqual((Object)declaration2.getName(), (Object)"START") || Intrinsics.areEqual((Object)declaration2.getName(), (Object)"END")) && Intrinsics.areEqual((Object)owner.getFqName(), (Object)"android.view.Gravity");
        }

        private final void checkVersion(UastAndroidContext context, UElement node, UDeclaration declaration2) {
            UElement uElement;
            if (declaration2 == null) {
                return;
            }
            ApiLookup apiLookup = ApiDetector.this.getMApiDatabase();
            if (apiLookup == null) {
                return;
            }
            ApiLookup db = apiLookup;
            int projectMinSdk = this.getMinSdk(context);
            if (projectMinSdk == -1) {
                return;
            }
            Function2<Integer, UClass, Unit> check$ = new Function2<Integer, UClass, Unit>(this, declaration2, context, node, projectMinSdk){
                final /* synthetic */ ApiVersionVisitor this$0;
                final /* synthetic */ UDeclaration $declaration;
                final /* synthetic */ UastAndroidContext $context;
                final /* synthetic */ UElement $node;
                final /* synthetic */ int $projectMinSdk;

                public final void invoke(int declarationSdkLevel, @Nullable UClass parentClass) {
                    if (declarationSdkLevel == -1) {
                        return;
                    }
                    if (parentClass != null && ApiVersionVisitor.access$checkIfSpecialCase(this.this$0, this.$declaration, parentClass)) {
                        return;
                    }
                    if (ApiDetector.Companion.isCheckedExplicitly(this.$context, declarationSdkLevel, this.$node)) {
                        return;
                    }
                    if (this.$projectMinSdk < declarationSdkLevel) {
                        UDeclaration uDeclaration = this.$declaration;
                        String subject = uDeclaration instanceof UFunction ? "Call" : (uDeclaration instanceof UVariable ? "Field" : (uDeclaration instanceof UClass ? "Class" : "Call"));
                        String message2 = subject + " requires API level " + declarationSdkLevel + (" (current min is " + this.$projectMinSdk + "): `" + this.$declaration.getName() + "`");
                        Issue issue = ApiDetector.UNSUPPORTED;
                        Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"UNSUPPORTED");
                        this.$context.report(issue, this.$node, this.$context.getLocation(this.$node), message2);
                        return;
                    }
                }
                {
                    this.this$0 = apiVersionVisitor;
                    this.$declaration = uDeclaration;
                    this.$context = uastAndroidContext;
                    this.$node = uElement;
                    this.$projectMinSdk = n;
                    super(2);
                }
            };
            checkVersion.2 checkAosp$ = checkVersion.2.INSTANCE;
            if (declaration2 instanceof UClass) {
                if (!this.isSdkClass((UClass)declaration2) || checkAosp$.invoke((UClass)declaration2)) {
                    return;
                }
                String string = ((UClass)declaration2).getInternalName();
                if (string == null) {
                    return;
                }
                String internalName2 = string;
                check$.invoke(db.getClassVersion(internalName2), (UClass)null);
            }
            if (!((uElement = declaration2.getParent()) instanceof UClass)) {
                uElement = null;
            }
            UClass uClass = (UClass)uElement;
            if (uClass == null) {
                return;
            }
            UClass parentClass = uClass;
            if (!this.isSdkClass(parentClass) || checkAosp$.invoke(parentClass)) {
                return;
            }
            String parentInternalName = parentClass.getInternalName();
            if (node instanceof UCallExpression) {
                String internalName3;
                UClass clazz;
                UClass uClass2;
                UAnnotated uAnnotated = ((UCallExpression)node).getReceiverType();
                if (uAnnotated != null && (uAnnotated = uAnnotated.resolveClass(context)) != null) {
                    UAnnotated uAnnotated2 = uAnnotated;
                    UClass it = (UClass)uAnnotated2;
                    uClass2 = this.getSupertypeFromAndroidSdk(context, it);
                } else {
                    uClass2 = null;
                }
                UClass uClass3 = clazz = uClass2;
                String string = internalName3 = uClass3 != null ? uClass3.getInternalName() : null;
                if (internalName3 != null) {
                    parentInternalName = internalName3;
                }
            }
            if (parentInternalName == null) {
                return;
            }
            UDeclaration uDeclaration = declaration2;
            if (uDeclaration instanceof UFunction) {
                String string = ((UFunction)declaration2).getBytecodeDescriptor();
                if (string == null) {
                    return;
                }
                String descriptor = string;
                check$.invoke(db.getCallVersion(parentInternalName, declaration2.getName(), descriptor), parentClass);
            } else if (uDeclaration instanceof UVariable) {
                JavaUType type2;
                if (Intrinsics.areEqual((Object)((UVariable)declaration2).getKind(), (Object)UastVariableKind.MEMBER) ^ true) {
                    return;
                }
                if (declaration2 instanceof JavaUVariable && ((JavaUVariable)declaration2).hasModifier(UastModifier.IMMUTABLE) && ((JavaUVariable)declaration2).hasModifier(UastModifier.STATIC) && Intrinsics.areEqual((Object)((JavaUVariable)declaration2).getVisibility(), (Object)UastVisibility.PUBLIC) && ((JavaUVariable)declaration2).getInitializer().evaluate() != null && ((type2 = ((JavaUVariable)declaration2).getType()).isPrimitive() || type2.isString())) {
                    return;
                }
                check$.invoke(db.getFieldVersion(parentInternalName, declaration2.getName()), parentClass);
            }
        }

        private final boolean isSdkClass(UClass clazz) {
            String string = clazz.getFqName();
            if (string == null) {
                return false;
            }
            String fqName = string;
            return StringsKt.startsWith$default((String)fqName, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName, (String)"dalvik.", (boolean)false, (int)2, null);
        }

        private final int getMinSdk(UastAndroidContext context) {
            if (this.mMinApi == -1) {
                AndroidVersion minSdkVersion = context.getLintContext().getMainProject().getMinSdkVersion();
                this.mMinApi = minSdkVersion.getFeatureLevel();
            }
            return this.mMinApi;
        }

        /*
         * WARNING - void declaration
         */
        private final UClass getSupertypeFromAndroidSdk(UastContext context, UClass clazz) {
            Object v1;
            block2: {
                void $receiver$iv;
                Function1<UClass, UClass> getSuperclassFromAndroidSdk$ = new Function1<UClass, UClass>(context){
                    final /* synthetic */ UastContext $context;

                    @Nullable
                    public final UClass invoke(@NotNull UClass clazz) {
                        while (true) {
                            Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
                            String string = clazz.getFqName();
                            if (string != null ? StringsKt.startsWith$default((String)string, (String)"android.", (boolean)false, (int)2, null) : false) {
                                return clazz;
                            }
                            if (clazz.getSuperClass(this.$context) != null) continue;
                            return null;
                        }
                    }
                    {
                        this.$context = uastContext;
                        super(1);
                    }
                };
                UClass superClass = getSuperclassFromAndroidSdk$.invoke(clazz);
                if (superClass != null) {
                    return superClass;
                }
                Iterable iterable = clazz.getSuperTypes();
                for (Object element$iv : $receiver$iv) {
                    UType it = (UType)element$iv;
                    String string = it.getFqName();
                    if (!(string != null ? StringsKt.startsWith$default((String)string, (String)"android.", (boolean)false, (int)2, null) : false)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            UType uType = v1;
            return uType != null ? uType.resolve(context) : null;
        }

        @NotNull
        public final UastAndroidContext getContext() {
            return this.context;
        }

        public ApiVersionVisitor(UastAndroidContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.mMinApi = -1;
        }

        public static final /* synthetic */ boolean access$checkIfSpecialCase(ApiVersionVisitor $this, @NotNull UDeclaration declaration2, @NotNull UClass owner) {
            return $this.checkIfSpecialCase(declaration2, owner);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0086\u0010J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/klint/checks/ApiDetector$Companion;", "", "()V", "AOSP_BUILD", "", "getAOSP_BUILD", "()Z", "INLINED", "Lcom/android/tools/klint/detector/api/Issue;", "Lcom/android/annotations/NonNull;", "OVERRIDE", "SDK_INT", "", "getSDK_INT", "()Ljava/lang/String;", "SDK_INT_CONTAINING", "getSDK_INT_CONTAINING", "UNSUPPORTED", "getLocalMinSdk", "", "scope", "Lorg/jetbrains/uast/UElement;", "getTargetApi", "annotations", "", "Lorg/jetbrains/uast/UAnnotation;", "isCheckedExplicitly", "context", "Lorg/jetbrains/uast/check/UastAndroidContext;", "requiredVersion", "node", "lint-checks"})
    public static final class Companion {
        private final boolean getAOSP_BUILD() {
            return AOSP_BUILD;
        }

        private final String getSDK_INT_CONTAINING() {
            return SDK_INT_CONTAINING;
        }

        private final String getSDK_INT() {
            return SDK_INT;
        }

        public final int getLocalMinSdk(@Nullable UElement scope) {
            while (scope != null) {
                int targetApi;
                if (scope instanceof UAnnotated && (targetApi = this.getTargetApi(((UAnnotated)scope).getAnnotations())) != -1) {
                    return targetApi;
                }
                scope = scope.getParent();
            }
            return -1;
        }

        public final int getTargetApi(@NotNull List<? extends UAnnotation> annotations2) {
            Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
            for (UAnnotation uAnnotation : annotations2) {
                if (!uAnnotation.matchesName("TargetApi")) continue;
                for (UNamedExpression element : uAnnotation.getValueArguments()) {
                    UExpression valueNode = element.getExpression();
                    if (UastLiteralUtils.isIntegralLiteral(valueNode)) {
                        UExpression uExpression = valueNode;
                        if (uExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.ULiteralExpression");
                        }
                        return (int)UastLiteralUtils.getLongValue((ULiteralExpression)uExpression);
                    }
                    if (UastLiteralUtils.isStringLiteral(valueNode)) {
                        UExpression uExpression = valueNode;
                        if (uExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.ULiteralExpression");
                        }
                        Object object = ((ULiteralExpression)uExpression).getValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        String value2 = (String)object;
                        return SdkVersionInfo.getApiByBuildCode((String)value2, (boolean)true);
                    }
                    if (valueNode instanceof UQualifiedExpression) {
                        String string = ((UQualifiedExpression)valueNode).getSelectorAsIdentifier();
                        if (string == null) {
                            return -1;
                        }
                        String codename = string;
                        return SdkVersionInfo.getApiByBuildCode((String)codename, (boolean)true);
                    }
                    if (!(valueNode instanceof USimpleReferenceExpression)) continue;
                    String codename = ((USimpleReferenceExpression)valueNode).getIdentifier();
                    return SdkVersionInfo.getApiByBuildCode((String)codename, (boolean)true);
                }
            }
            return -1;
        }

        public final boolean isCheckedExplicitly(@NotNull UastAndroidContext context, int requiredVersion, @NotNull UElement node) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Function1<UExpression, Boolean> isSdkIntReference$ = new Function1<UExpression, Boolean>(context){
                final /* synthetic */ UastAndroidContext $context;

                public final boolean invoke(@NotNull UExpression $receiver) {
                    boolean bl;
                    UExpression uExpression;
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        uExpression = $receiver;
                        if (!(uExpression instanceof UParenthesizedExpression)) break;
                        $receiver = ((UParenthesizedExpression)$receiver).getExpression();
                    }
                    if (uExpression instanceof USimpleReferenceExpression) {
                        UDeclaration uDeclaration = ((USimpleReferenceExpression)$receiver).resolve(this.$context);
                        bl = uDeclaration != null ? uDeclaration.matchesNameWithContaining(com.android.tools.klint.checks.ApiDetector$Companion.access$getSDK_INT_CONTAINING$p(ApiDetector.Companion), com.android.tools.klint.checks.ApiDetector$Companion.access$getSDK_INT$p(ApiDetector.Companion)) : false;
                    } else if (uExpression instanceof UQualifiedExpression) {
                        UDeclaration uDeclaration = ((UQualifiedExpression)$receiver).resolve(this.$context);
                        bl = uDeclaration != null ? uDeclaration.matchesNameWithContaining(com.android.tools.klint.checks.ApiDetector$Companion.access$getSDK_INT_CONTAINING$p(ApiDetector.Companion), com.android.tools.klint.checks.ApiDetector$Companion.access$getSDK_INT$p(ApiDetector.Companion)) : false;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$context = uastAndroidContext;
                    super(1);
                }
            };
            Function2<UExpression, Boolean, Boolean> checkCondition$ = new Function2<UExpression, Boolean, Boolean>(isSdkIntReference$, context, requiredVersion){
                final /* synthetic */ isCheckedExplicitly.1 $isSdkIntReference;
                final /* synthetic */ UastAndroidContext $context;
                final /* synthetic */ int $requiredVersion;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Boolean invoke(@NotNull UExpression node, boolean invertCondition) {
                    Boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (node instanceof UBinaryExpression && ((UBinaryExpression)node).getOperator() instanceof UastBinaryOperator.ComparationOperator) {
                        void invert;
                        UExpression value2;
                        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                        booleanRef.element = invertCondition;
                        if (this.$isSdkIntReference.invoke(((UBinaryExpression)node).getLeftOperand())) {
                            value2 = ((UBinaryExpression)node).getRightOperand();
                        } else if (this.$isSdkIntReference.invoke(((UBinaryExpression)node).getRightOperand())) {
                            invert.element = !invert.element;
                            value2 = ((UBinaryExpression)node).getLeftOperand();
                        } else {
                            return false;
                        }
                        Function1<Boolean, Boolean> inv$ = new Function1<Boolean, Boolean>((Ref.BooleanRef)invert){
                            final /* synthetic */ Ref.BooleanRef $invert;

                            public final boolean invoke(boolean cond) {
                                return this.$invert.element ? !cond : cond;
                            }
                            {
                                this.$invert = booleanRef;
                                super(1);
                            }
                        };
                        Function1<UExpression, Integer> evaluateValue$ = new Function1<UExpression, Integer>(this){
                            final /* synthetic */ isCheckedExplicitly.2 this$0;

                            @Nullable
                            public final Integer invoke(@Nullable UExpression value2) {
                                Integer n;
                                block5: {
                                    block6: {
                                        while (true) {
                                            UDeclaration declaration2;
                                            if (value2 == null) {
                                                return null;
                                            }
                                            Object object = value2.evaluate();
                                            if (!(object instanceof Number)) {
                                                object = null;
                                            }
                                            Number number = (Number)object;
                                            if (number != null) {
                                                n = number.intValue();
                                                break block5;
                                            }
                                            if (!(value2 instanceof UResolvable)) break block6;
                                            if (((UResolvable)((Object)value2)).resolve(this.this$0.$context) == null) {
                                                return null;
                                            }
                                            if (!(declaration2 instanceof UVariable)) break;
                                            value2 = ((UVariable)declaration2).getInitializer();
                                        }
                                        n = null;
                                        break block5;
                                    }
                                    n = null;
                                }
                                return n;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        };
                        Integer n = evaluateValue$.invoke(value2);
                        if (n == null) {
                            return null;
                        }
                        int sdkLevel = n;
                        UastBinaryOperator uastBinaryOperator = ((UBinaryExpression)node).getOperator();
                        return Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? Boolean.valueOf(inv$.invoke(sdkLevel > this.$requiredVersion)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUAL) ? Boolean.valueOf(sdkLevel == this.$requiredVersion || inv$.invoke(sdkLevel > this.$requiredVersion)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? Boolean.valueOf(inv$.invoke(sdkLevel < this.$requiredVersion)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUAL) ? Boolean.valueOf(sdkLevel == this.$requiredVersion || inv$.invoke(sdkLevel < this.$requiredVersion)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? Boolean.valueOf(this.$requiredVersion == sdkLevel) : (Boolean)null))));
                    }
                    UExpression uExpression = node;
                    if (uExpression instanceof UBinaryExpression) {
                        if (((UBinaryExpression)node).getOperator() instanceof UastBinaryOperator.LogicalOperator) {
                            bl = isCheckedExplicitly.2.invoke$default(this, ((UBinaryExpression)node).getLeftOperand(), false, 2, null);
                            if (bl == null) {
                                bl = isCheckedExplicitly.2.invoke$default(this, ((UBinaryExpression)node).getRightOperand(), false, 2, null);
                            }
                        } else {
                            bl = null;
                        }
                    } else {
                        bl = uExpression instanceof UUnaryExpression ? (Intrinsics.areEqual((Object)((UUnaryExpression)node).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) ? this.invoke(((UUnaryExpression)node).getOperand(), true) : (Boolean)null) : (uExpression instanceof UParenthesizedExpression ? isCheckedExplicitly.2.invoke$default(this, ((UParenthesizedExpression)node).getExpression(), false, 2, null) : (Boolean)null);
                    }
                    return bl;
                }

                @Nullable
                public static /* bridge */ /* synthetic */ Boolean invoke$default(isCheckedExplicitly.2 var0, UExpression uExpression, boolean bl, int n, Object object) {
                    if (object != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invoke");
                    }
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return var0.invoke(uExpression, bl);
                }
                {
                    this.$isSdkIntReference = var1_1;
                    this.$context = uastAndroidContext;
                    this.$requiredVersion = n;
                    super(2);
                }
            };
            Function3<UElement, UElement, UastAndroidContext, Boolean> check$ = new Function3<UElement, UElement, UastAndroidContext, Boolean>(checkCondition$){
                final /* synthetic */ isCheckedExplicitly.2 $checkCondition;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke(@Nullable UElement node, @Nullable UElement prev, @NotNull UastAndroidContext context) {
                    boolean bl;
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                        UElement uElement = node;
                        if (Intrinsics.areEqual((Object)uElement, null)) {
                            bl = false;
                            break;
                        }
                        if (uElement instanceof UIfExpression) {
                            Boolean bl2 = isCheckedExplicitly.2.invoke$default(this.$checkCondition, ((UIfExpression)node).getCondition(), false, 2, null);
                            if (bl2 == null) {
                                return false;
                            }
                            boolean cond = bl2;
                            if (cond && Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)node).getThenBranch()) || !cond && Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)node).getElseBranch())) {
                                bl = true;
                                break;
                            }
                            prev = node;
                            node = node.getParent();
                            continue;
                        }
                        if (uElement instanceof USwitchClauseExpression) {
                            boolean bl3;
                            block16: {
                                List<UExpression> list = ((USwitchClauseExpression)node).getCaseValues();
                                if (list != null) {
                                    void $receiver$iv;
                                    Iterable cond = list;
                                    for (T element$iv : $receiver$iv) {
                                        UExpression it = (UExpression)element$iv;
                                        if (!Intrinsics.areEqual((Object)isCheckedExplicitly.2.invoke$default(this.$checkCondition, it, false, 2, null), (Object)true)) continue;
                                        bl3 = true;
                                        break block16;
                                    }
                                    bl3 = false;
                                } else {
                                    bl3 = false;
                                }
                            }
                            if (bl3) {
                                bl = true;
                                break;
                            }
                            prev = node;
                            node = node.getParent();
                            continue;
                        }
                        if (uElement instanceof UBinaryExpression) {
                            if (Intrinsics.areEqual((Object)prev, (Object)((UBinaryExpression)node).getRightOperand()) && ((UBinaryExpression)node).getOperator() instanceof UastBinaryOperator.LogicalOperator && Intrinsics.areEqual((Object)isCheckedExplicitly.2.invoke$default(this.$checkCondition, ((UBinaryExpression)node).getLeftOperand(), false, 2, null), (Object)true)) {
                                bl = true;
                                break;
                            }
                            prev = node;
                            node = node.getParent();
                            continue;
                        }
                        if (uElement instanceof UFunction) {
                            bl = false;
                            break;
                        }
                        if (uElement instanceof UVariable) {
                            if (Intrinsics.areEqual((Object)((UVariable)node).getKind(), (Object)UastVariableKind.MEMBER)) {
                                bl = false;
                                break;
                            }
                            prev = node;
                            node = node.getParent();
                            continue;
                        }
                        if (uElement instanceof UClass) {
                            bl = false;
                            break;
                        }
                        prev = node;
                        node = node.getParent();
                    }
                    return bl;
                }
                {
                    this.$checkCondition = var1_1;
                    super(3);
                }
            };
            int minSdk = this.getLocalMinSdk(node);
            if (minSdk != -1 && minSdk >= requiredVersion) {
                return true;
            }
            return check$.invoke(node, (UElement)null, context);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$getAOSP_BUILD$p(Companion $this) {
            return $this.getAOSP_BUILD();
        }

        @NotNull
        public static final /* synthetic */ String access$getSDK_INT_CONTAINING$p(Companion $this) {
            return $this.getSDK_INT_CONTAINING();
        }

        @NotNull
        public static final /* synthetic */ String access$getSDK_INT$p(Companion $this) {
            return $this.getSDK_INT();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

