/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import org.jetbrains.uast.check.UastScanner;

public class CommentDetector
extends Detector
implements UastScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue EASTER_EGG = Issue.create("EasterEgg", "Code contains easter egg", "An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create("StopShip", "Code contains `STOPSHIP` marker", "Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these.", Category.CORRECTNESS, 10, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";
    private static final boolean USE_AST = false;

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }
}

