/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class ToastDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("ShowToast", "Toast created but not shown", "`Toast.makeText()` creates a `Toast` but does *not* show it. You must call `show()` on the resulting object to actually make the `Toast` appear.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ToastDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("makeText");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UFunction method;
        UExpression duration;
        assert ("makeText".equals(node.getFunctionName()));
        UElement qualifiedExpression = node.getParent();
        if (!(qualifiedExpression instanceof UQualifiedExpression)) {
            return;
        }
        if (!UastUtils.endsWithQualified(((UQualifiedExpression)qualifiedExpression).getReceiver(), "Toast")) {
            return;
        }
        List<UExpression> args = node.getValueArguments();
        if (args.size() == 3 && (duration = args.get(2)) instanceof ULiteralExpression && ((ULiteralExpression)duration).getValue() instanceof Number) {
            context.report(ISSUE, duration, context.getLocation(duration), "Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported");
        }
        if ((method = UastUtils.getContainingFunction(node.getParent())) == null) {
            return;
        }
        UExpression nodeWithPossibleQualifier = UastUtils.getQualifiedCallElement(node);
        ShowFinder finder = new ShowFinder(nodeWithPossibleQualifier);
        method.accept(finder);
        if (!finder.isShowCalled()) {
            context.report(ISSUE, node, context.getLocation(node), "Toast created but not shown: did you forget to call `show()` ?");
        }
    }

    private static class ShowFinder
    extends AbstractUastVisitor {
        private final UExpression mTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private ShowFinder(UExpression target) {
            this.mTarget = target;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ToastDetector$ShowFinder", "visitCallExpression"));
            }
            if (node.equals(this.mTarget)) {
                this.mSeenTarget = true;
            } else if (this.mSeenTarget && node.matchesFunctionName("show")) {
                this.mFound = true;
            }
            return super.visitCallExpression(node);
        }

        @Override
        public boolean visitQualifiedExpression(@NotNull UQualifiedExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ToastDetector$ShowFinder", "visitQualifiedExpression"));
            }
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            }
            return super.visitQualifiedExpression(node);
        }

        @Override
        public boolean visitReturnExpression(@NotNull UReturnExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ToastDetector$ShowFinder", "visitReturnExpression"));
            }
            if (UastLintUtils.isChildOfExpression(this.mTarget, node.getReturnExpression())) {
                this.mFound = true;
            }
            return super.visitReturnExpression(node);
        }

        boolean isShowCalled() {
            return this.mFound && this.mSeenTarget;
        }
    }
}

