/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class WrongImportDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("SuspiciousImport", "'`import android.R`' statement", "Importing `android.R` is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on `android.R` are not the ones you'd expect from just looking at your own `R` class.", Category.CORRECTNESS, 9, Severity.WARNING, new Implementation(WrongImportDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new ImportVisitor(context);
    }

    private static class ImportVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public ImportVisitor(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitImportStatement(@NotNull UImportStatement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/WrongImportDetector$ImportVisitor", "visitImportStatement"));
            }
            String fqn = node.getFqNameToImport();
            if (fqn != null && fqn.equals("android.R")) {
                Location location = this.mContext.getLocation(node);
                this.mContext.report(ISSUE, node, location, "Don't include `android.R` here; use a fully qualified name for each usage instead");
            }
            return false;
        }
    }
}

