/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UImportStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
public class LintUtils {
    private static final String UTF_16 = "UTF_16";
    private static final String UTF_16LE = "UTF_16LE";
    public static boolean sTryPrefixLookup = true;

    private LintUtils() {
    }

    @NonNull
    public static String formatList(@NonNull List<String> strings, int maxItems) {
        StringBuilder sb = new StringBuilder(20 * strings.size());
        int n = strings.size();
        for (int i = 0; i < n; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(strings.get(i));
            if (maxItems <= 0 || i != maxItems - 1 || n <= maxItems) continue;
            sb.append(String.format("... (%1$d more)", n - i - 1));
            break;
        }
        return sb.toString();
    }

    public static boolean isFileBasedResourceType(@NonNull ResourceType type2) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type2);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type2 != ResourceType.ID;
        }
        return false;
    }

    public static boolean isXmlFile(@NonNull File file) {
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml");
    }

    public static boolean isBitmapFile(@NonNull File file) {
        String path = file.getPath();
        return LintUtils.endsWith(path, ".png") || LintUtils.endsWith(path, ".jpg") || LintUtils.endsWith(path, ".gif") || LintUtils.endsWith(path, ".jpeg") || LintUtils.endsWith(path, ".webp");
    }

    public static boolean endsWith(@NonNull String string, @NonNull String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean startsWith(@NonNull String string, @NonNull String prefix, int offset) {
        return string.regionMatches(true, offset, prefix, 0, prefix.length());
    }

    public static String getBaseName(@NonNull String fileName) {
        int extension = fileName.indexOf(46);
        if (extension > 0) {
            return fileName.substring(0, extension);
        }
        return fileName;
    }

    @NonNull
    public static List<Element> getChildren(@NonNull Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(childNodes.getLength());
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            children.add((Element)child);
        }
        return children;
    }

    public static int getChildCount(@NonNull Node node) {
        NodeList childNodes = node.getChildNodes();
        int childCount = 0;
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            ++childCount;
        }
        return childCount;
    }

    public static boolean isRootElement(Element element) {
        return element == element.getOwnerDocument().getDocumentElement();
    }

    @NonNull
    public static String stripIdPrefix(@Nullable String id) {
        if (id == null) {
            return "";
        }
        if (id.startsWith("@+id/")) {
            return id.substring("@+id/".length());
        }
        if (id.startsWith("@id/")) {
            return id.substring("@id/".length());
        }
        return id;
    }

    public static boolean idReferencesMatch(@Nullable String id1, @Nullable String id2) {
        if (id1 == null || id2 == null || id1.isEmpty() || id2.isEmpty()) {
            return false;
        }
        if (id1.startsWith("@+id/")) {
            if (id2.startsWith("@+id/")) {
                return id1.equals(id2);
            }
            assert (id2.startsWith("@id/")) : id2;
            return id1.length() - id2.length() == "@+id/".length() - "@id/".length() && id1.regionMatches("@+id/".length(), id2, "@id/".length(), id2.length() - "@id/".length());
        }
        assert (id1.startsWith("@id/")) : id1;
        if (id2.startsWith("@id/")) {
            return id1.equals(id2);
        }
        assert (id2.startsWith("@+id/"));
        return id2.length() - id1.length() == "@+id/".length() - "@id/".length() && id2.regionMatches("@+id/".length(), id1, "@id/".length(), id1.length() - "@id/".length());
    }

    public static int editDistance(@NonNull String s, @NonNull String t) {
        int j;
        int m = s.length();
        int n = t.length();
        int[][] d = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                if (s.charAt(i - 1) == t.charAt(j - 1)) {
                    d[i][j] = d[i - 1][j - 1];
                    continue;
                }
                int deletion = d[i - 1][j] + 1;
                int insertion = d[i][j - 1] + 1;
                int substitution = d[i - 1][j - 1] + 1;
                d[i][j] = Math.min(deletion, Math.min(insertion, substitution));
            }
        }
        return d[m][n];
    }

    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    public static String getLayoutName(File layoutFile) {
        String name2 = layoutFile.getName();
        int dotIndex = name2.indexOf(46);
        if (dotIndex != -1) {
            name2 = name2.substring(0, dotIndex);
        }
        return name2;
    }

    public static Iterable<String> splitPath(@NonNull String path) {
        if (path.indexOf(59) != -1) {
            return Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path);
        }
        ArrayList<String> combined = new ArrayList<String>();
        Iterables.addAll(combined, (Iterable)Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)path));
        int n = combined.size();
        for (int i = 0; i < n; ++i) {
            String p = (String)combined.get(i);
            if (p.length() != 1 || i >= n - 1 || !Character.isLetter(p.charAt(0)) || ((String)combined.get(i + 1)).isEmpty() || ((String)combined.get(i + 1)).charAt(0) != '\\') continue;
            combined.set(i, p + ':' + (String)combined.get(i + 1));
            combined.remove(i + 1);
            --n;
        }
        return combined;
    }

    @Nullable
    public static File getCommonParent(@NonNull List<File> files) {
        int fileCount = files.size();
        if (fileCount == 0) {
            return null;
        }
        if (fileCount == 1) {
            return files.get(0);
        }
        if (fileCount == 2) {
            return LintUtils.getCommonParent(files.get(0), files.get(1));
        }
        File common = files.get(0);
        for (int i = 1; i < fileCount; ++i) {
            if ((common = LintUtils.getCommonParent(common, files.get(i))) != null) continue;
            return null;
        }
        return common;
    }

    @Nullable
    public static File getCommonParent(@NonNull File file1, @NonNull File file2) {
        if (file1.equals(file2)) {
            return file1;
        }
        if (file1.getPath().startsWith(file2.getPath())) {
            return file2;
        }
        if (file2.getPath().startsWith(file1.getPath())) {
            return file1;
        }
        for (File first = file1.getParentFile(); first != null; first = first.getParentFile()) {
            for (File second = file2.getParentFile(); second != null; second = second.getParentFile()) {
                if (!first.equals(second)) continue;
                return first;
            }
        }
        return null;
    }

    @NonNull
    public static String getEncodedString(@NonNull LintClient client, @NonNull File file) throws IOException {
        byte[] bytes = client.readBytes(file);
        if (LintUtils.endsWith(file.getName(), ".xml")) {
            return PositionXmlParser.getXmlString((byte[])bytes);
        }
        return LintUtils.getEncodedString(bytes);
    }

    @NonNull
    public static String getEncodedString(@Nullable byte[] data) {
        if (data == null) {
            return "";
        }
        int offset = 0;
        String defaultCharset = "UTF-8";
        String charset = null;
        if (data.length > 4) {
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                charset = "UTF-8";
                defaultCharset = "UTF-8";
                offset += 3;
            } else if (data[0] == -2 && data[1] == -1) {
                charset = UTF_16;
                defaultCharset = UTF_16;
                offset += 2;
            } else if (data[0] == 0 && data[1] == 0 && data[2] == -2 && data[3] == -1) {
                charset = "UTF_32";
                defaultCharset = "UTF_32";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2 && data[2] == 0 && data[3] == 0) {
                charset = "UTF_32LE";
                defaultCharset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2) {
                charset = UTF_16LE;
                defaultCharset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        for (int lineEnd = offset; lineEnd < data.length; ++lineEnd) {
            if (data[lineEnd] == 0) {
                if ((lineEnd - offset) % 2 == 0) {
                    seenEvenZero = true;
                    continue;
                }
                seenOddZero = true;
                continue;
            }
            if (data[lineEnd] == 10 || data[lineEnd] == 13) break;
        }
        if (charset == null) {
            charset = seenOddZero ? UTF_16LE : (seenEvenZero ? UTF_16 : "UTF-8");
        }
        String text = null;
        try {
            text = new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                if (charset != defaultCharset) {
                    text = new String(data, offset, length, defaultCharset);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (text == null) {
            text = new String(data, offset, length);
        }
        return text;
    }

    public static boolean isStaticInnerClass(@NonNull ClassNode classNode) {
        List fieldList = classNode.fields;
        for (Object f : fieldList) {
            FieldNode field = (FieldNode)f;
            if (!field.name.startsWith("this$") || (field.access & 0x1000) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnonymousClass(@NonNull ClassNode classNode) {
        if (classNode.outerClass == null) {
            return false;
        }
        String name2 = classNode.name;
        int index = name2.lastIndexOf(36);
        if (index == -1 || index == name2.length() - 1) {
            return false;
        }
        return Character.isDigit(name2.charAt(index + 1));
    }

    public static int getPrevOpcode(@NonNull AbstractInsnNode node) {
        AbstractInsnNode prev = LintUtils.getPrevInstruction(node);
        if (prev != null) {
            return prev.getOpcode();
        }
        return 0;
    }

    @Nullable
    public static AbstractInsnNode getPrevInstruction(@NonNull AbstractInsnNode node) {
        int type2;
        AbstractInsnNode prev = node;
        do {
            if ((prev = prev.getPrevious()) != null) continue;
            return null;
        } while ((type2 = prev.getType()) == 15 || type2 == 8 || type2 == 14);
        return prev;
    }

    public static int getNextOpcode(@NonNull AbstractInsnNode node) {
        AbstractInsnNode next = LintUtils.getNextInstruction(node);
        if (next != null) {
            return next.getOpcode();
        }
        return 0;
    }

    @Nullable
    public static AbstractInsnNode getNextInstruction(@NonNull AbstractInsnNode node) {
        int type2;
        AbstractInsnNode next = node;
        do {
            if ((next = next.getNext()) != null) continue;
            return null;
        } while ((type2 = next.getType()) == 15 || type2 == 8 || type2 == 14);
        return next;
    }

    public static boolean isManifestFolder(File dir) {
        boolean hasManifest = new File(dir, "AndroidManifest.xml").exists();
        if (hasManifest && dir.getName().equals("bin") && (dir = dir.getParentFile()) != null && LintUtils.isManifestFolder(dir)) {
            return false;
        }
        return hasManifest;
    }

    @Nullable
    public static String getLocaleAndRegion(@NonNull String folderName) {
        if (folderName.indexOf(45) == -1) {
            return null;
        }
        String locale = null;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName)) {
            char second;
            char first;
            int qualifierLength = qualifier.length();
            if (qualifierLength == 2) {
                first = qualifier.charAt(0);
                second = qualifier.charAt(1);
                if (first < 'a' || first > 'z' || second < 'a' || second > 'z') continue;
                locale = qualifier;
                continue;
            }
            if (qualifierLength == 3 && qualifier.charAt(0) == 'r' && locale != null) {
                first = qualifier.charAt(1);
                second = qualifier.charAt(2);
                if (first < 'A' || first > 'Z' || second < 'A' || second > 'Z') break;
                return locale + '-' + qualifier;
            }
            if (!qualifier.startsWith("b+")) continue;
            return qualifier;
        }
        return locale;
    }

    public static boolean isImported(@Nullable UFile compilationUnit, @NonNull String fullyQualifiedName) {
        if (compilationUnit == null) {
            return false;
        }
        int dotIndex = fullyQualifiedName.lastIndexOf(46);
        int dotLength = fullyQualifiedName.length() - dotIndex;
        boolean imported = false;
        for (UImportStatement importStatement : compilationUnit.getImportStatements()) {
            String fqn = importStatement.getFqNameToImport();
            if (fqn == null) continue;
            if (fqn.equals(fullyQualifiedName)) {
                return true;
            }
            if (fullyQualifiedName.regionMatches(dotIndex, fqn, fqn.length() - dotLength, dotLength)) {
                return false;
            }
            if (!importStatement.isStarImport() || !fqn.regionMatches(0, fqn, 0, dotIndex + 1)) continue;
            imported = true;
        }
        return imported;
    }

    @Nullable
    public static List<ResourceValue> getStyleAttributes(@NonNull Project project, @NonNull LintClient client, @NonNull String styleUrl, @NonNull String namespace, @NonNull String attribute) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        AbstractResourceRepository resources2 = client.getProjectResources(project, true);
        if (resources2 == null) {
            return null;
        }
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.framework) {
            return null;
        }
        ArrayList result = null;
        ArrayDeque<ResourceValue> queue = new ArrayDeque<ResourceValue>();
        queue.add(new ResourceValue(style.type, style.name, false));
        HashSet seen = Sets.newHashSet();
        boolean isFrameworkAttribute = "http://schemas.android.com/apk/res/android".equals(namespace);
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name2 = front.getName();
            seen.add(name2);
            List items = resources2.getResourceItem(front.getResourceType(), name2);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                String parent;
                ResourceValue rv = item.getResourceValue(false);
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                ItemResourceValue value2 = srv.getItem(attribute, isFrameworkAttribute);
                if (value2 != null) {
                    if (result == null) {
                        result = Lists.newArrayList();
                    }
                    if (!result.contains(value2)) {
                        result.add(value2);
                    }
                }
                if (!((parent = srv.getParentStyle()) == null || parent.startsWith("@android:") || (p = ResourceUrl.parse((String)parent)) == null || p.framework || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValue(ResourceType.STYLE, p.name, false));
                }
                if ((index = name2.lastIndexOf(46)) <= 0 || seen.contains(parentName = name2.substring(0, index))) continue;
                seen.add(parentName);
                queue.add(new ResourceValue(ResourceType.STYLE, parentName, false));
            }
        }
        return result;
    }

    @Nullable
    public static List<StyleResourceValue> getInheritedStyles(@NonNull Project project, @NonNull LintClient client, @NonNull String styleUrl) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        AbstractResourceRepository resources2 = client.getProjectResources(project, true);
        if (resources2 == null) {
            return null;
        }
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.framework) {
            return null;
        }
        ArrayList result = null;
        ArrayDeque<ResourceValue> queue = new ArrayDeque<ResourceValue>();
        queue.add(new ResourceValue(style.type, style.name, false));
        HashSet seen = Sets.newHashSet();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name2 = front.getName();
            seen.add(name2);
            List items = resources2.getResourceItem(front.getResourceType(), name2);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue(false);
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                if (result == null) {
                    result = Lists.newArrayList();
                }
                result.add(srv);
                String parent = srv.getParentStyle();
                if (!(parent == null || parent.startsWith("@android:") || (p = ResourceUrl.parse((String)parent)) == null || p.framework || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValue(ResourceType.STYLE, p.name, false));
                }
                if ((index = name2.lastIndexOf(46)) <= 0 || seen.contains(parentName = name2.substring(0, index))) continue;
                seen.add(parentName);
                queue.add(new ResourceValue(ResourceType.STYLE, parentName, false));
            }
        }
        return result;
    }

    public static boolean isSameResourceFile(@Nullable File file1, @Nullable File file2) {
        if (file1 != null && file2 != null && file1.getName().equals(file2.getName())) {
            File parent1 = file1.getParentFile();
            File parent2 = file2.getParentFile();
            if (parent1 != null && parent2 != null && parent1.getName().equals(parent2.getName())) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String computeResourcePrefix(@Nullable AndroidProject project) {
        try {
            if (sTryPrefixLookup && project != null) {
                return project.getResourcePrefix();
            }
        }
        catch (Exception e) {
            sTryPrefixLookup = false;
        }
        return null;
    }

    public static String computeResourceName(@NonNull String prefix, @NonNull String name2) {
        if (prefix.isEmpty()) {
            return name2;
        }
        if (name2.isEmpty()) {
            return prefix;
        }
        if (prefix.endsWith("_")) {
            return prefix + name2;
        }
        return prefix + Character.toUpperCase(name2.charAt(0)) + name2.substring(1);
    }

    @NonNull
    public static AndroidVersion convertVersion(@NonNull ApiVersion api, @Nullable IAndroidTarget[] targets) {
        String codename = api.getCodename();
        if (codename != null) {
            AndroidVersion version = SdkVersionInfo.getVersion((String)codename, (IAndroidTarget[])targets);
            if (version != null) {
                return version;
            }
            return new AndroidVersion(api.getApiLevel(), codename);
        }
        return new AndroidVersion(api.getApiLevel(), null);
    }

    @Nullable
    public static String findSubstring(@NonNull String string, @Nullable String prefix, @Nullable String suffix) {
        int start = 0;
        if (prefix != null) {
            start = string.indexOf(prefix);
            if (start == -1) {
                return null;
            }
            start += prefix.length();
        }
        if (suffix != null) {
            int end = string.indexOf(suffix, start);
            if (end == -1) {
                return null;
            }
            return string.substring(start, end);
        }
        return string.substring(start);
    }

    @NonNull
    public static List<String> getFormattedParameters(@NonNull String format, @NonNull String errorMessage) {
        StringBuilder pattern = new StringBuilder(format.length());
        int parameter = 1;
        int n = format.length();
        for (int i = 0; i < n; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                assert (i < format.length() - 4) : format;
                assert (format.charAt(i + 1) == 48 + parameter) : format;
                assert (Character.isDigit(format.charAt(i + 1))) : format;
                assert (format.charAt(i + 2) == '$') : format;
                assert (format.charAt(i + 3) == 's') : format;
                ++parameter;
                i += 3;
                pattern.append("(.*)");
                continue;
            }
            pattern.append(c);
        }
        try {
            Pattern compile = Pattern.compile(pattern.toString());
            Matcher matcher = compile.matcher(errorMessage);
            if (matcher.find()) {
                int groupCount = matcher.groupCount();
                ArrayList parameters2 = Lists.newArrayListWithExpectedSize((int)groupCount);
                for (int i = 1; i <= groupCount; ++i) {
                    parameters2.add(matcher.group(i));
                }
                return parameters2;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NonNull
    public static String escapePropertyValue(@NonNull String value2) {
        Properties properties = new Properties();
        properties.setProperty("k", value2);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s = writer.toString();
            int end = s.length();
            String lineSeparator = SdkUtils.getLineSeparator();
            if (s.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s.indexOf(61);
            assert (start != -1) : s;
            return s.substring(start + 1, end);
        }
        catch (IOException e) {
            return value2;
        }
    }

    @Nullable
    public static LocaleQualifier getLocale(@NonNull String parent) {
        FolderConfiguration config;
        if (parent.indexOf(45) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parent)) != null) {
            return config.getLocaleQualifier();
        }
        return null;
    }

    @Nullable
    public static LocaleQualifier getLocale(@NonNull XmlContext context) {
        String locale;
        Element root = context.document.getDocumentElement();
        if (root != null && (locale = root.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !locale.isEmpty()) {
            return LintUtils.getLocale(locale);
        }
        return LintUtils.getLocale(context.file.getParentFile().getName());
    }

    public static boolean isEnglishResource(@NonNull XmlContext context, boolean assumeForBase) {
        LocaleQualifier locale = LintUtils.getLocale(context);
        if (locale == null) {
            return assumeForBase;
        }
        return "en".equals(locale.getLanguage());
    }
}

