/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.tools.klint.checks.BuiltinIssueRegistry;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class IntellijLintIssueRegistry
extends BuiltinIssueRegistry {
    private static List<Issue> ourFilteredIssues;

    @Override
    @NonNull
    public List<Issue> getIssues() {
        if (ourFilteredIssues == null) {
            List<Issue> sIssues = super.getIssues();
            ArrayList<Issue> result = new ArrayList<Issue>(sIssues.size());
            for (Issue issue : sIssues) {
                Implementation implementation = issue.getImplementation();
                EnumSet<Scope> scope = implementation.getScope();
                Class<? extends Detector> detectorClass = implementation.getDetectorClass();
                if (detectorClass == SupportAnnotationDetector.class) continue;
                if (scope.contains((Object)Scope.CLASS_FILE) || scope.contains((Object)Scope.ALL_CLASS_FILES) || scope.contains((Object)Scope.JAVA_LIBRARIES)) {
                    boolean isOk = false;
                    for (EnumSet<Scope> analysisScope : implementation.getAnalysisScopes()) {
                        if (analysisScope.contains((Object)Scope.CLASS_FILE) || analysisScope.contains((Object)Scope.ALL_CLASS_FILES) || analysisScope.contains((Object)Scope.JAVA_LIBRARIES)) continue;
                        isOk = true;
                        break;
                    }
                    if (!isOk) continue;
                }
                result.add(issue);
            }
            ourFilteredIssues = result;
        }
        return ourFilteredIssues;
    }
}

