/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.tools.klint.detector.api.Issue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.inspections.klint.ProblemData;
import org.jetbrains.annotations.NotNull;

public class State {
    private final Module myModule;
    private final VirtualFile myMainFile;
    private final String myMainFileContent;
    private final List<ProblemData> myProblems;
    private final List<Issue> myIssues;
    private volatile boolean myDirty;

    State(@NotNull Module module, @NotNull VirtualFile mainFile, @NotNull String mainFileContent, @NotNull List<Issue> issues) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/inspections/klint/State", "<init>"));
        }
        if (mainFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFile", "org/jetbrains/android/inspections/klint/State", "<init>"));
        }
        if (mainFileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFileContent", "org/jetbrains/android/inspections/klint/State", "<init>"));
        }
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "org/jetbrains/android/inspections/klint/State", "<init>"));
        }
        this.myProblems = new ArrayList<ProblemData>();
        this.myModule = module;
        this.myMainFile = mainFile;
        this.myMainFileContent = mainFileContent;
        this.myIssues = issues;
    }

    @NotNull
    public VirtualFile getMainFile() {
        VirtualFile virtualFile = this.myMainFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/State", "getMainFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getMainFileContent() {
        String string = this.myMainFileContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/State", "getMainFileContent"));
        }
        return string;
    }

    public void markDirty() {
        this.myDirty = true;
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/State", "getModule"));
        }
        return module;
    }

    @NotNull
    public List<ProblemData> getProblems() {
        List<ProblemData> list = this.myProblems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/State", "getProblems"));
        }
        return list;
    }

    @NotNull
    public List<Issue> getIssues() {
        List<Issue> list = this.myIssues;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/State", "getIssues"));
        }
        return list;
    }
}

