/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.jetbrains.annotations.NotNull;

public class XPathHighlighter
extends SyntaxHighlighterBase {
    private static final Map keys1;
    private static final Map keys1_2;
    private static final Map keys2;
    private final boolean myXPath2Syntax;
    static final TextAttributesKey XPATH_KEYWORD;
    static final TextAttributesKey XPATH_STRING;
    static final TextAttributesKey XPATH_NUMBER;
    static final TextAttributesKey XPATH_OPERATION_SIGN;
    static final TextAttributesKey XPATH_PARENTH;
    static final TextAttributesKey XPATH_BRACKET;
    static final TextAttributesKey XPATH_FUNCTION;
    static final TextAttributesKey XPATH_VARIABLE;
    static final TextAttributesKey XPATH_PREFIX;
    static final TextAttributesKey XPATH_NAME;
    static final TextAttributesKey XPATH_TEXT;

    public XPathHighlighter(boolean xpath2Syntax) {
        this.myXPath2Syntax = xpath2Syntax;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = XPathLexer.create(this.myXPath2Syntax);
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathHighlighter", "getHighlightingLexer"));
        }
        return lexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = XPathHighlighter.pack((TextAttributesKey)((TextAttributesKey)(this.myXPath2Syntax ? keys1_2 : keys1).get(tokenType)), (TextAttributesKey)((TextAttributesKey)keys2.get(tokenType)));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        XPATH_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"XPATH.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        XPATH_STRING = TextAttributesKey.createTextAttributesKey((String)"XPATH.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        XPATH_NUMBER = TextAttributesKey.createTextAttributesKey((String)"XPATH.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        XPATH_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"XPATH.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        XPATH_PARENTH = TextAttributesKey.createTextAttributesKey((String)"XPATH.PARENTH", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        XPATH_BRACKET = TextAttributesKey.createTextAttributesKey((String)"XPATH.BRACKET", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        XPATH_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"XPATH.FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_CALL);
        XPATH_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"XPATH.XPATH_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        XPATH_PREFIX = TextAttributesKey.createTextAttributesKey((String)"XPATH.XPATH_PREFIX", (TextAttributesKey)HighlighterColors.TEXT);
        XPATH_NAME = TextAttributesKey.createTextAttributesKey((String)"XPATH.XPATH_NAME", (TextAttributesKey)HighlighterColors.TEXT);
        XPATH_TEXT = TextAttributesKey.createTextAttributesKey((String)"XPATH.XPATH_TEXT", (TextAttributesKey)HighlighterColors.TEXT);
        keys1 = new HashMap();
        keys2 = new HashMap();
        XPathHighlighter.fillMap((Map)keys1, (TokenSet)XPathTokenTypes.BINARY_OPERATIONS, (TextAttributesKey)XPATH_OPERATION_SIGN);
        XPathHighlighter.fillMap((Map)keys1, (TokenSet)XPathTokenTypes.KEYWORDS, (TextAttributesKey)XPATH_KEYWORD);
        XPathHighlighter.fillMap((Map)keys1, (TokenSet)XPathTokenTypes.REST, (TextAttributesKey)XPATH_TEXT);
        keys1.put(XPathTokenTypes.NCNAME, XPATH_NAME);
        keys1.put(XPathTokenTypes.NUMBER, XPATH_NUMBER);
        keys1.put(XPathTokenTypes.STRING_LITERAL, XPATH_STRING);
        keys1.put(XPathTokenTypes.FUNCTION_NAME, XPATH_FUNCTION);
        keys1.put(XPathTokenTypes.EXT_PREFIX, XPATH_PREFIX);
        keys1.put(XPathTokenTypes.DOLLAR, XPATH_VARIABLE);
        keys1.put(XPathTokenTypes.VARIABLE_NAME, XPATH_VARIABLE);
        keys1.put(XPathTokenTypes.VARIABLE_PREFIX, XPATH_PREFIX);
        keys1.put(XPathTokenTypes.LPAREN, XPATH_PARENTH);
        keys1.put(XPathTokenTypes.LBRACKET, XPATH_BRACKET);
        keys1.put(XPathTokenTypes.RPAREN, XPATH_PARENTH);
        keys1.put(XPathTokenTypes.RBRACKET, XPATH_BRACKET);
        keys1.put(XPathTokenTypes.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        keys1.put(XPathTokenTypes.BAD_AXIS_NAME, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
        keys1_2 = new HashMap(keys1);
        XPathHighlighter.fillMap((Map)keys1_2, (TokenSet)XPath2TokenTypes.KEYWORDS, (TextAttributesKey)XPATH_KEYWORD);
    }
}

