/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableDeclaration;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XPath2VariableImpl
extends XPathElementImpl
implements XPathVariable {
    public XPath2VariableImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathExpression value = this.getValue();
        XPathType xPathType = value != null ? value.getType() : XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2VariableImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    public XPathExpression getValue() {
        XPathVariableDeclaration d = (XPathVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this, XPathVariableDeclaration.class);
        if (d != null) {
            return d.getInitializer();
        }
        return null;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public String getName() {
        return this.getText().substring(1);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/lang/xpath/psi/impl/XPath2VariableImpl", "setName"));
        }
        return this.replace(XPathChangeUtil.createVariableReference(this, name));
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathVariable(this);
    }
}

