/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathLocationPathImpl
extends XPathElementImpl
implements XPathLocationPath {
    public XPathLocationPathImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathExpression expr;
        XPathStep step = this.getFirstStep();
        if (step != null && (expr = step.getStep()) != null) {
            XPathType xPathType = expr.getType();
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathLocationPathImpl", "getType"));
            }
            return xPathType;
        }
        XPathType xPathType = this.getXPathVersion() == XPathVersion.V1 ? XPathType.NODESET : XPath2Type.SEQUENCE;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathLocationPathImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    @Nullable
    public XPathStep getFirstStep() {
        return (XPathStep)this.findChildByClass(XPathStep.class);
    }

    @Override
    public boolean isAbsolute() {
        XPathStep pathExpression = this.getFirstStep();
        return pathExpression instanceof XPathStep && pathExpression.isAbsolute();
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathLocationPath(this);
    }
}

