/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixBasedPropertyReference
extends PropertyReference {
    private boolean myPrefixEvaluated;
    private boolean myDynamicPrefix;
    @Nullable
    private String myKeyPrefix;
    @NonNls
    private static final String PREFIX_ATTR_NAME = "prefix";

    public PrefixBasedPropertyReference(String key, PsiElement element, @Nullable String bundleName, boolean soft) {
        super(key, element, bundleName, soft);
    }

    @NotNull
    protected String getKeyText() {
        String keyText = super.getKeyText();
        String keyPrefix = this.getKeyPrefix();
        if (keyPrefix != null) {
            keyText = keyPrefix + keyText;
        }
        String string = keyText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PrefixBasedPropertyReference", "getKeyText"));
        }
        return string;
    }

    protected void addKey(Object property, Set<Object> variants) {
        String key = ((IProperty)property).getUnescapedKey();
        String keyPrefix = this.getKeyPrefix();
        if (keyPrefix != null && key != null) {
            if (!key.startsWith(keyPrefix)) {
                return;
            }
            key = key.substring(keyPrefix.length());
            super.addKey((Object)key, variants);
        }
        super.addKey(property, variants);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String keyPrefix = this.getKeyPrefix();
        if (keyPrefix != null) {
            if (newElementName.startsWith(keyPrefix)) {
                newElementName = newElementName.substring(keyPrefix.length());
            } else {
                throw new IncorrectOperationException(PropertiesBundle.message((String)"rename.prefix.based.property.key.error.message", (Object[])new Object[]{keyPrefix, this.getCanonicalText(), newElementName}));
            }
        }
        return super.handleElementRename(newElementName);
    }

    @Nullable
    private String getKeyPrefix() {
        if (!this.myPrefixEvaluated) {
            PsiElement curParent = PsiTreeUtil.getParentOfType((PsiElement)this.getElement().getParent().getParent(), XmlTag.class);
            while (curParent instanceof XmlTag) {
                XmlTag curParentTag = (XmlTag)curParent;
                if ("bundle".equals(curParentTag.getLocalName()) && Arrays.binarySearch(XmlUtil.JSTL_FORMAT_URIS, curParentTag.getNamespace()) >= 0) {
                    String attributeValue = curParentTag.getAttributeValue(PREFIX_ATTR_NAME);
                    if (attributeValue == null || attributeValue.length() <= 0) break;
                    XmlAttributeValue valueElement = curParentTag.getAttribute(PREFIX_ATTR_NAME, null).getValueElement();
                    if (PropertiesReferenceProvider.isNonDynamicAttribute((PsiElement)valueElement)) {
                        this.myKeyPrefix = attributeValue;
                        break;
                    }
                    this.myDynamicPrefix = true;
                    break;
                }
                curParent = curParent.getParent();
            }
            this.myPrefixEvaluated = true;
        }
        return this.myKeyPrefix;
    }

    public boolean isDynamicPrefix() {
        return this.myDynamicPrefix;
    }
}

