/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourceCachingBuildTarget
extends AndroidBuildTarget {
    public AndroidResourceCachingBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget", "<init>"));
        }
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (extension != null) {
            ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
            for (File resOverlayDir : extension.getResourceOverlayDirs()) {
                result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, resOverlayDir));
            }
            File resourceDir = AndroidJpsUtil.getResourceDirForCompilationPath(extension);
            if (resourceDir != null) {
                result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, resourceDir));
            }
            if (!extension.isLibrary()) {
                HashSet aarResDirPaths = new HashSet();
                AndroidJpsUtil.collectResDirectoriesFromAarDeps(this.myModule, (Collection<String>)aarResDirPaths);
                for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
                    AndroidJpsUtil.collectResDirectoriesFromAarDeps(depExtension.getModule(), (Collection<String>)aarResDirPaths);
                }
                for (String path : aarResDirPaths) {
                    result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(path)));
                }
            }
            ArrayList<BuildRootDescriptor> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget", "doComputeRootDescriptors"));
            }
            return arrayList;
        }
        List<BuildRootDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget", "doComputeRootDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputDir(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget", "getOutputRoots"));
        }
        return list;
    }

    @NotNull
    public File getOutputDir(CompileContext context) {
        File file = AndroidJpsUtil.getResourcesCacheDir(this.myModule, context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget", "getOutputDir"));
        }
        return file;
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidResourceCachingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-resource-caching", "Resource Caching");
        }

        @Override
        public AndroidResourceCachingBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidResourceCachingBuildTarget$MyTargetType", "createBuildTarget"));
            }
            return new AndroidResourceCachingBuildTarget(extension.getModule());
        }
    }
}

