/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.TtyConnectorWaitFor;
import com.jediterm.terminal.ui.AbstractTabs;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalPanelListener;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.TerminalTabs;
import com.jediterm.terminal.ui.TerminalTabsImpl;
import com.jediterm.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import com.jediterm.terminal.util.JTextFieldLimit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedTerminalWidget
extends JPanel
implements TerminalWidget,
TerminalActionProvider {
    private final Object myLock = new Object();
    private TerminalPanelListener myTerminalPanelListener = null;
    private JediTermWidget myTermWidget = null;
    private TerminalTabs myTabs;
    private TabbedSettingsProvider mySettingsProvider;
    private List<TabListener> myTabListeners = Lists.newArrayList();
    private TerminalActionProvider myNextActionProvider;
    private final Predicate<TerminalWidget> myCreateNewSessionAction;
    private JPanel myPanel;

    public TabbedTerminalWidget(@NotNull TabbedSettingsProvider settingsProvider, @NotNull Predicate<TerminalWidget> createNewSessionAction) {
        super(new BorderLayout());
        this.mySettingsProvider = settingsProvider;
        this.myCreateNewSessionAction = createNewSessionAction;
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this, "Center");
    }

    @Override
    public TerminalSession createTerminalSession(TtyConnector ttyConnector) {
        JediTermWidget terminal = this.createInnerTerminalWidget(this.mySettingsProvider);
        terminal.createTerminalSession(ttyConnector);
        terminal.setNextProvider(this);
        this.setupTtyConnectorWaitFor(ttyConnector, terminal);
        if (this.myTerminalPanelListener != null) {
            terminal.setTerminalPanelListener(this.myTerminalPanelListener);
        }
        if (this.myTermWidget == null && this.myTabs == null) {
            this.myTermWidget = terminal;
            Dimension size = terminal.getComponent().getSize();
            this.add((Component)this.myTermWidget.getComponent(), "Center");
            this.setSize(size);
            if (this.myTerminalPanelListener != null) {
                this.myTerminalPanelListener.onPanelResize(size, RequestOrigin.User);
            }
            this.onSessionChanged();
        } else {
            if (this.myTabs == null) {
                this.myTabs = this.setupTabs();
            }
            this.addTab(terminal, this.myTabs);
        }
        return terminal;
    }

    protected JediTermWidget createInnerTerminalWidget(TabbedSettingsProvider settingsProvider) {
        return new JediTermWidget(settingsProvider);
    }

    protected void setupTtyConnectorWaitFor(final TtyConnector ttyConnector, final JediTermWidget widget) {
        new TtyConnectorWaitFor(ttyConnector, Executors.newSingleThreadExecutor()).setTerminationCallback(new Predicate<Integer>(){

            public boolean apply(Integer integer) {
                if (TabbedTerminalWidget.this.mySettingsProvider.shouldCloseTabOnLogout(ttyConnector)) {
                    TabbedTerminalWidget.this.closeTab(widget);
                }
                return true;
            }
        });
    }

    private void addTab(JediTermWidget terminal, TerminalTabs tabs) {
        String name = TabbedTerminalWidget.generateUniqueName(this.mySettingsProvider.tabName(terminal.getTtyConnector(), terminal.getSessionName()), tabs);
        this.addTab(terminal, tabs, name);
    }

    private void addTab(JediTermWidget terminal, TerminalTabs tabs, String name) {
        tabs.addTab(name, terminal);
        tabs.setTabComponentAt(tabs.getTabCount() - 1, this.createTabComponent(tabs, terminal));
        tabs.setSelectedComponent(terminal);
    }

    public void addTab(String name, JediTermWidget terminal) {
        if (this.myTabs == null) {
            this.myTabs = this.setupTabs();
        }
        this.addTab(terminal, this.myTabs, name);
    }

    private static String generateUniqueName(String suggestedName, TerminalTabs tabs) {
        HashSet names = Sets.newHashSet();
        for (int i = 0; i < tabs.getTabCount(); ++i) {
            names.add(tabs.getTitleAt(i));
        }
        String newSdkName = suggestedName;
        int i = 0;
        while (names.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }

    private TerminalTabs setupTabs() {
        TerminalTabs tabs = this.createTabbedPane();
        tabs.addChangeListener(new AbstractTabs.TabChangeListener(){

            public void tabRemoved() {
                if (TabbedTerminalWidget.this.myTabs.getTabCount() == 1) {
                    TabbedTerminalWidget.this.removeTabbedPane();
                }
            }

            public void selectionChanged() {
                TabbedTerminalWidget.this.onSessionChanged();
            }
        });
        this.remove(this.myTermWidget);
        this.addTab(this.myTermWidget, tabs);
        this.myTermWidget = null;
        this.add((Component)tabs.getComponent(), "Center");
        return tabs;
    }

    public boolean isNoActiveSessions() {
        return this.myTabs == null && this.myTermWidget == null;
    }

    private void onSessionChanged() {
        JediTermWidget session = this.getCurrentSession();
        if (session != null) {
            if (this.myTerminalPanelListener != null) {
                this.myTerminalPanelListener.onSessionChanged(session);
            }
            session.getTerminalPanel().requestFocusInWindow();
        }
    }

    protected TerminalTabs createTabbedPane() {
        return new TerminalTabsImpl();
    }

    protected Component createTabComponent(TerminalTabs tabs, JediTermWidget terminal) {
        return new TabComponent(tabs, terminal);
    }

    public void closeTab(final JediTermWidget terminal) {
        if (terminal != null) {
            if (this.myTabs != null && this.myTabs.indexOfComponent(terminal) != -1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TabbedTerminalWidget.this.removeTab(terminal);
                    }
                });
                this.fireTabClosed(terminal);
            } else if (this.myTermWidget == terminal) {
                this.myTermWidget = null;
                this.fireTabClosed(terminal);
            }
        }
    }

    public void closeCurrentSession() {
        JediTermWidget session = this.getCurrentSession();
        session.close();
        this.closeTab(session);
    }

    public void dispose() {
        for (TerminalSession terminalSession : this.getAllTerminalSessions()) {
            if (terminalSession == null) continue;
            terminalSession.close();
        }
    }

    private List<JediTermWidget> getAllTerminalSessions() {
        ArrayList session = Lists.newArrayList();
        if (this.myTabs != null) {
            for (int i = 0; i < this.myTabs.getTabCount(); ++i) {
                session.add(this.getTerminalPanel(i));
            }
        } else if (this.myTermWidget != null) {
            session.add(this.myTermWidget);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTab(JediTermWidget terminal) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTabs != null) {
                this.myTabs.remove(terminal);
            }
            this.onSessionChanged();
        }
    }

    private void removeTabbedPane() {
        this.myTermWidget = this.getTerminalPanel(0);
        this.myTabs.removeAll();
        this.remove(this.myTabs.getComponent());
        this.myTabs = null;
        this.add((Component)this.myTermWidget.getComponent(), "Center");
    }

    @Override
    public List<TerminalAction> getActions() {
        return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("New Session", this.mySettingsProvider.getNewSessionKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TabbedTerminalWidget.this.handleNewSession();
                return true;
            }
        }).withMnemonicKey(78), new TerminalAction("Close Session", this.mySettingsProvider.getCloseSessionKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TabbedTerminalWidget.this.closeCurrentSession();
                return true;
            }
        }).withMnemonicKey(83), new TerminalAction("Next Tab", this.mySettingsProvider.getNextTabKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TabbedTerminalWidget.this.selectNextTab();
                return true;
            }
        }).withEnabledSupplier(new Supplier<Boolean>(){

            public Boolean get() {
                return TabbedTerminalWidget.this.myTabs != null && TabbedTerminalWidget.this.myTabs.getSelectedIndex() < TabbedTerminalWidget.this.myTabs.getTabCount() - 1;
            }
        }), new TerminalAction("Previous Tab", this.mySettingsProvider.getPreviousTabKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TabbedTerminalWidget.this.selectPreviousTab();
                return true;
            }
        }).withEnabledSupplier(new Supplier<Boolean>(){

            public Boolean get() {
                return TabbedTerminalWidget.this.myTabs != null && TabbedTerminalWidget.this.myTabs.getSelectedIndex() > 0;
            }
        })});
    }

    private void selectPreviousTab() {
        this.myTabs.setSelectedIndex(this.myTabs.getSelectedIndex() - 1);
    }

    private void selectNextTab() {
        this.myTabs.setSelectedIndex(this.myTabs.getSelectedIndex() + 1);
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider provider) {
        this.myNextActionProvider = provider;
    }

    private void handleNewSession() {
        this.myCreateNewSessionAction.apply((Object)this);
    }

    public Component getFocusableComponent() {
        return this.myTabs != null ? this.myTabs.getComponent() : (this.myTermWidget != null ? this.myTermWidget : this);
    }

    public TerminalTabs getTerminalTabs() {
        return this.myTabs;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public boolean canOpenSession() {
        return true;
    }

    @Override
    public void setTerminalPanelListener(TerminalPanelListener terminalPanelListener) {
        if (this.myTabs != null) {
            for (int i = 0; i < this.myTabs.getTabCount(); ++i) {
                this.getTerminalPanel(i).setTerminalPanelListener(terminalPanelListener);
            }
        } else if (this.myTermWidget != null) {
            this.myTermWidget.setTerminalPanelListener(terminalPanelListener);
        }
        this.myTerminalPanelListener = terminalPanelListener;
    }

    @Override
    @Nullable
    public JediTermWidget getCurrentSession() {
        if (this.myTabs != null) {
            return this.getTerminalPanel(this.myTabs.getSelectedIndex());
        }
        return this.myTermWidget;
    }

    @Override
    public TerminalDisplay getTerminalDisplay() {
        return this.getCurrentSession().getTerminalDisplay();
    }

    @Nullable
    private JediTermWidget getTerminalPanel(int index) {
        if (index < this.myTabs.getTabCount() && index >= 0) {
            return (JediTermWidget)this.myTabs.getComponentAt(index);
        }
        return null;
    }

    public void addTabListener(TabListener listener) {
        this.myTabListeners.add(listener);
    }

    public void removeTabListener(TabListener listener) {
        this.myTabListeners.remove(listener);
    }

    private void fireTabClosed(JediTermWidget terminal) {
        for (TabListener l : this.myTabListeners) {
            l.tabClosed(terminal);
        }
    }

    public static interface TabListener {
        public void tabClosed(JediTermWidget var1);
    }

    private class TabComponent
    extends JPanel
    implements FocusListener {
        private JediTermWidget myTerminal;
        private MyLabelHolder myLabelHolder;

        private TabComponent(final TerminalTabs tabs, final JediTermWidget terminal) {
            super(new FlowLayout(0, 0, 0));
            this.myLabelHolder = new MyLabelHolder();
            this.myTerminal = terminal;
            this.setOpaque(false);
            this.setFocusable(false);
            this.addFocusListener(this);
            TabComponentLabel label = new TabComponentLabel();
            label.addFocusListener(this);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            label.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent event) {
                    TabComponent.this.handleMouse(event);
                }

                public void mousePressed(MouseEvent event) {
                    tabs.setSelectedComponent(terminal);
                    TabComponent.this.handleMouse(event);
                }
            });
            this.myLabelHolder.set(label);
            this.add(this.myLabelHolder);
        }

        protected void handleMouse(MouseEvent event) {
            if (event.isPopupTrigger()) {
                JPopupMenu menu = this.createPopup();
                menu.show(event.getComponent(), event.getX(), event.getY());
            } else if (event.getClickCount() == 2 && !event.isConsumed()) {
                event.consume();
                this.renameTab();
            }
        }

        protected JPopupMenu createPopup() {
            JPopupMenu popupMenu = new JPopupMenu();
            TerminalAction.addToMenu(popupMenu, TabbedTerminalWidget.this);
            JMenuItem rename = new JMenuItem("Rename Tab");
            rename.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TabComponent.this.renameTab();
                }
            });
            popupMenu.add(rename);
            return popupMenu;
        }

        private void renameTab() {
            int selectedIndex = TabbedTerminalWidget.this.myTabs.getSelectedIndex();
            JLabel label = (JLabel)this.myLabelHolder.getComponent(0);
            new TabRenamer().install(selectedIndex, label.getText(), label, new TabRenamer.RenameCallBack(){

                public void setComponent(Component c) {
                    TabComponent.this.myLabelHolder.set(c);
                }

                public void setNewName(int index, String name) {
                    if (TabbedTerminalWidget.this.myTabs != null) {
                        TabbedTerminalWidget.this.myTabs.setTitleAt(index, name);
                    }
                }
            });
        }

        public void focusGained(FocusEvent e) {
            this.myTerminal.getComponent().requestFocusInWindow();
        }

        public void focusLost(FocusEvent e) {
        }

        class TabComponentLabel
        extends JLabel {
            TabComponentLabel() {
            }

            TabComponent getTabComponent() {
                return TabComponent.this;
            }

            public String getText() {
                int i;
                if (TabbedTerminalWidget.this.myTabs != null && (i = TabbedTerminalWidget.this.myTabs.indexOfTabComponent(TabComponent.this)) != -1) {
                    return TabbedTerminalWidget.this.myTabs.getTitleAt(i);
                }
                return null;
            }
        }

        private class MyLabelHolder
        extends JPanel {
            private MyLabelHolder() {
            }

            public void set(Component c) {
                TabComponent.this.myLabelHolder.removeAll();
                TabComponent.this.myLabelHolder.add(c);
                TabComponent.this.myLabelHolder.validate();
                TabComponent.this.myLabelHolder.repaint();
            }
        }
    }

    public static class TabRenamer {
        public void install(final int selectedIndex, String text, final Component label, final RenameCallBack callBack) {
            final JTextField textField = this.createTextField();
            textField.setOpaque(false);
            textField.setDocument(new JTextFieldLimit(50));
            textField.setText(text);
            final FocusAdapter focusAdapter = new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    TabRenamer.finishRename(selectedIndex, label, textField.getText(), callBack);
                }
            };
            textField.addFocusListener(focusAdapter);
            textField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        textField.removeFocusListener(focusAdapter);
                        TabRenamer.finishRename(selectedIndex, label, null, callBack);
                    } else if (keyEvent.getKeyCode() == 10) {
                        textField.removeFocusListener(focusAdapter);
                        TabRenamer.finishRename(selectedIndex, label, textField.getText(), callBack);
                    } else {
                        super.keyPressed(keyEvent);
                    }
                }
            });
            callBack.setComponent(textField);
            textField.requestFocus();
            textField.selectAll();
        }

        protected JTextField createTextField() {
            return new JTextField();
        }

        private static void finishRename(int index, Component label, String newName, RenameCallBack callBack) {
            if (newName != null) {
                callBack.setNewName(index, newName);
            }
            callBack.setComponent(label);
        }

        public static interface RenameCallBack {
            public void setComponent(Component var1);

            public void setNewName(int var1, String var2);
        }
    }
}

