/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenRunnerSettings
implements Cloneable {
    @NonNls
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    @NonNls
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    @NonNls
    public static final String USE_JAVA_HOME = "#JAVA_HOME";
    private boolean runMavenInBackground = true;
    @NotNull
    private String jreName = "#USE_PROJECT_JDK";
    @NotNull
    private String vmOptions = "";
    private boolean skipTests = false;
    private Map<String, String> mavenProperties = new LinkedHashMap<String, String>();
    private Map<String, String> environmentProperties = new HashMap();
    private boolean passParentEnv = true;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isRunMavenInBackground() {
        return this.runMavenInBackground;
    }

    public void setRunMavenInBackground(boolean runMavenInBackground) {
        this.runMavenInBackground = runMavenInBackground;
    }

    @NotNull
    public String getJreName() {
        String string = this.jreName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerSettings", "getJreName"));
        }
        return string;
    }

    public void setJreName(@Nullable String jreName) {
        if (jreName != null) {
            this.jreName = jreName;
        }
    }

    @NotNull
    public String getVmOptions() {
        String string = this.vmOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerSettings", "getVmOptions"));
        }
        return string;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        if (vmOptions != null) {
            this.vmOptions = vmOptions;
        }
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        if (skipTests != this.skipTests) {
            this.fireSkipTestsChanged();
        }
        this.skipTests = skipTests;
    }

    public Map<String, String> getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Map<String, String> mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    @NotNull
    public Map<String, String> getEnvironmentProperties() {
        Map<String, String> map = this.environmentProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerSettings", "getEnvironmentProperties"));
        }
        return map;
    }

    public void setEnvironmentProperties(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "org/jetbrains/idea/maven/execution/MavenRunnerSettings", "setEnvironmentProperties"));
        }
        if (envs == this.environmentProperties) {
            return;
        }
        this.environmentProperties.clear();
        this.environmentProperties.putAll(envs);
    }

    public boolean isPassParentEnv() {
        return this.passParentEnv;
    }

    public void setPassParentEnv(boolean passParentEnv) {
        this.passParentEnv = passParentEnv;
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireSkipTestsChanged() {
        for (Listener each : this.myListeners) {
            each.skipTestsChanged();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerSettings that = (MavenRunnerSettings)o;
        if (this.runMavenInBackground != that.runMavenInBackground) {
            return false;
        }
        if (this.skipTests != that.skipTests) {
            return false;
        }
        if (!this.jreName.equals(that.jreName)) {
            return false;
        }
        if (this.mavenProperties != null ? !this.mavenProperties.equals(that.mavenProperties) : that.mavenProperties != null) {
            return false;
        }
        if (!this.vmOptions.equals(that.vmOptions)) {
            return false;
        }
        if (!this.environmentProperties.equals(that.environmentProperties)) {
            return false;
        }
        return this.passParentEnv == that.passParentEnv;
    }

    public int hashCode() {
        int result = this.runMavenInBackground ? 1 : 0;
        result = 31 * result + this.jreName.hashCode();
        result = 31 * result + this.vmOptions.hashCode();
        result = 31 * result + (this.skipTests ? 1 : 0);
        result = 31 * result + this.environmentProperties.hashCode();
        result = 31 * result + (this.mavenProperties != null ? this.mavenProperties.hashCode() : 0);
        return result;
    }

    public MavenRunnerSettings clone() {
        try {
            MavenRunnerSettings clone = (MavenRunnerSettings)super.clone();
            clone.mavenProperties = MavenRunnerSettings.cloneMap(this.mavenProperties);
            clone.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            clone.environmentProperties = new HashMap(this.environmentProperties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static <K, V> Map<K, V> cloneMap(Map<K, V> source) {
        LinkedHashMap<K, V> clone = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public static interface Listener {
        public void skipTestsChanged();
    }
}

