/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.Url;

public class Path {
    private final String path;

    public Path(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/utils/Path", "<init>"));
        }
        path = PathUtil.getCanonicalPath((String)path);
        this.path = path = FileUtil.toSystemIndependentName((String)path);
    }

    @NotNull
    public String getPath() {
        String string = this.path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/Path", "getPath"));
        }
        return string;
    }

    public Url toUrl() {
        return new Url(VfsUtil.pathToUrl((String)this.path));
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Path && this.path.equals(((Path)o).path);
    }
}

