/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.propertiesEditor;

import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;
import org.jetbrains.idea.maven.utils.library.remote.MavenVersionsRemoteManager;

public class RepositoryLibraryPropertiesEditor {
    @NotNull
    private final Project project;
    State currentState;
    List<String> versions;
    private VersionKind versionKind;
    private RepositoryLibraryPropertiesModel initialModel;
    private RepositoryLibraryPropertiesModel model;
    private RepositoryLibraryDescription repositoryLibraryDescription;
    private ComboBox versionKindSelector;
    private ComboBox versionSelector;
    private JPanel mainPanel;
    private JButton myReloadButton;
    private JPanel versionPanel;
    private JPanel failedToLoadPanel;
    private JPanel loadingPanel;
    private JBCheckBox downloadSourcesCheckBox;
    private JBCheckBox downloadJavaDocsCheckBox;
    private JBLabel mavenCoordinates;
    @NotNull
    private ModelChangeListener onChangeListener;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project, RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description) {
        this(project, model, description, new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor editor) {
            }
        });
    }

    public RepositoryLibraryPropertiesEditor(@Nullable Project project, final RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description, final @NotNull ModelChangeListener onChangeListener) {
        if (onChangeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChangeListener", "org/jetbrains/idea/maven/utils/library/propertiesEditor/RepositoryLibraryPropertiesEditor", "<init>"));
        }
        this.$$$setupUI$$$();
        this.initialModel = model.clone();
        this.model = model;
        this.project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        this.repositoryLibraryDescription = description;
        this.mavenCoordinates.setCopyable(true);
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.onChangeListener = new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor editor) {
                onChangeListener.onChange(editor);
                RepositoryLibraryPropertiesEditor.this.mavenCoordinates.setText(RepositoryLibraryPropertiesEditor.this.repositoryLibraryDescription.getMavenCoordinates(model.getVersion()));
            }
        };
        this.reloadVersionsAsync();
    }

    private static VersionKind getVersionKind(String version) {
        if (Strings.isNullOrEmpty((String)version)) {
            return VersionKind.Unselected;
        }
        if (version.equals("RELEASE")) {
            return VersionKind.Release;
        }
        if (version.equals("LATEST")) {
            return VersionKind.Latest;
        }
        return VersionKind.Select;
    }

    private static int getSelection(String selectedVersion, List<String> versions) {
        VersionKind versionKind = RepositoryLibraryPropertiesEditor.getVersionKind(selectedVersion);
        int releaseIndex = JBIterable.from(versions).takeWhile(version -> version.endsWith("-SNAPSHOT")).size();
        switch (versionKind) {
            case Unselected: {
                return -1;
            }
            case Release: {
                return releaseIndex == versions.size() ? -1 : releaseIndex;
            }
            case Latest: {
                return 0;
            }
            case Select: {
                if (versions.indexOf(selectedVersion) == -1) {
                    versions.add(0, selectedVersion);
                }
                return versions.indexOf(selectedVersion);
            }
        }
        return -1;
    }

    private void initVersionKindSelector() {
        List<String> versionKinds = Arrays.asList(ProjectBundle.message("maven.version.kind.selector.release", new Object[0]), ProjectBundle.message("maven.version.kind.selector.latest", new Object[0]), ProjectBundle.message("maven.version.kind.selector.select", new Object[0]));
        CollectionComboBoxModel versionKindSelectorModel = new CollectionComboBoxModel(versionKinds);
        this.versionKindSelector.setModel((ComboBoxModel)versionKindSelectorModel);
        this.versionKindSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VersionKind newVersionKind = RepositoryLibraryPropertiesEditor.this.getSelectedVersionKind();
                if (newVersionKind != RepositoryLibraryPropertiesEditor.this.versionKind) {
                    RepositoryLibraryPropertiesEditor.this.versionKind = newVersionKind;
                    RepositoryLibraryPropertiesEditor.this.versionKindChanged();
                }
            }
        });
        this.setSelectedVersionKind(RepositoryLibraryPropertiesEditor.getVersionKind(this.model.getVersion()));
    }

    private void versionKindChanged() {
        this.versionSelector.setEnabled(this.versionKind == VersionKind.Select);
        this.model.setVersion(this.getSelectedVersion());
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.model.getVersion(), this.versions);
        this.versionSelector.setSelectedIndex(selection);
        this.onChangeListener.onChange(this);
    }

    private VersionKind getSelectedVersionKind() {
        switch (this.versionKindSelector.getSelectedIndex()) {
            case 0: {
                return VersionKind.Release;
            }
            case 1: {
                return VersionKind.Latest;
            }
            case 2: {
                return VersionKind.Select;
            }
        }
        return VersionKind.Unselected;
    }

    private void setSelectedVersionKind(VersionKind versionKind) {
        this.versionSelector.setEnabled(versionKind == VersionKind.Select);
        switch (versionKind) {
            case Unselected: {
                this.versionKindSelector.setSelectedIndex(-1);
                break;
            }
            case Release: {
                this.versionKindSelector.setSelectedItem((Object)0);
                break;
            }
            case Latest: {
                this.versionKindSelector.setSelectedIndex(1);
                break;
            }
            case Select: {
                this.versionKindSelector.setSelectedIndex(2);
            }
        }
    }

    private void setState(State state) {
        this.currentState = state;
        this.versionPanel.setVisible(state == State.Loaded);
        this.failedToLoadPanel.setVisible(state == State.FailedToLoad);
        this.loadingPanel.setVisible(state == State.Loading);
        this.onChangeListener.onChange(this);
    }

    private void reloadVersionsAsync() {
        this.setState(State.Loading);
        MavenVersionsRemoteManager.getInstance(this.project).getMavenArtifactVersionsAsync(this.repositoryLibraryDescription.getGroupId(), this.repositoryLibraryDescription.getArtifactId(), new MavenRemoteTask.ResultProcessor<List<String>>(){

            @Override
            public void process(@Nullable List<String> versions) {
                RepositoryLibraryPropertiesEditor.this.versionsLoaded(versions);
            }
        });
    }

    private void initVersionsPanel() {
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.model.getVersion(), this.versions);
        CollectionComboBoxModel versionSelectorModel = new CollectionComboBoxModel(this.versions);
        this.versionSelector.setModel((ComboBoxModel)versionSelectorModel);
        this.versionSelector.setSelectedIndex(selection);
        this.setState(State.Loaded);
        this.initVersionKindSelector();
        this.versionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadSourcesCheckBox.setSelected(this.model.isDownloadSources());
        this.downloadSourcesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadSources(RepositoryLibraryPropertiesEditor.this.downloadSourcesCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadJavaDocsCheckBox.setSelected(this.model.isDownloadJavaDocs());
        this.downloadJavaDocsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadJavaDocs(RepositoryLibraryPropertiesEditor.this.downloadJavaDocsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
    }

    private void versionsLoaded(@Nullable List<String> versions) {
        this.versions = versions;
        if (versions == null || versions.isEmpty()) {
            this.versionsFailedToLoad();
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::initVersionsPanel, ModalityState.any());
    }

    private void versionsFailedToLoad() {
        ApplicationManager.getApplication().invokeLater(() -> this.setState(State.FailedToLoad), ModalityState.any());
    }

    public String getSelectedVersion() {
        switch (this.versionKind) {
            case Unselected: {
                return null;
            }
            case Release: {
                return "RELEASE";
            }
            case Latest: {
                return "LATEST";
            }
            case Select: {
                return (String)this.versionSelector.getSelectedItem();
            }
        }
        return null;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isValid() {
        return this.currentState == State.Loaded;
    }

    public boolean hasChanges() {
        return !this.model.equals(this.initialModel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        JPanel jPanel2;
        JButton jButton;
        JPanel jPanel3;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.failedToLoadPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Failed to load versions");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReloadButton = jButton = new JButton();
        jButton.setText("Reload");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.loadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setInheritsPopupMenu(true);
        jBLabel3.setText("Loading available versions...");
        jBLabel3.setDisplayedMnemonic('L');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.versionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Version:");
        jBLabel4.setDisplayedMnemonic('V');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.versionSelector = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.versionKindSelector = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.downloadSourcesCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel("Download Sources");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("ProjectBundle").getString("maven.property.download.sources"));
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.downloadJavaDocsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setLabel("Download JavaDocs");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("ProjectBundle").getString("maven.property.download.javadocs"));
        jPanel6.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Maven:");
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mavenCoordinates = jBLabel = new JBLabel();
        jBLabel.setRequestFocusEnabled(true);
        jBLabel.setOpaque(false);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        jBLabel3.setLabelFor((Component)comboBox2);
        jBLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }

    private static enum VersionKind {
        Unselected,
        Release,
        Latest,
        Select;

    }

    public static interface ModelChangeListener {
        public void onChange(RepositoryLibraryPropertiesEditor var1);
    }
}

