/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.beust.jcommander.JCommander;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.net.NetUtils;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGVersionChecker;
import com.theoryinpractice.testng.model.IDEARemoteTestRunnerClient;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGRemoteListener;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGResults;
import com.theoryinpractice.testng.ui.actions.RerunFailedTestsAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.testng.RemoteTestNGStarter;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.strprotocol.SerializedMessageSender;

public class TestNGRunnableState
extends JavaTestFrameworkRunnableState<TestNGConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"TestNG Runner");
    private static final String TESTNG_TEST_FRAMEWORK_NAME = "TestNG";
    private final TestNGConfiguration config;
    protected final IDEARemoteTestRunnerClient client;
    private int port;

    public TestNGRunnableState(ExecutionEnvironment environment, TestNGConfiguration config) {
        super(environment);
        this.config = config;
        this.client = new IDEARemoteTestRunnerClient();
        this.setRemoteConnectionCreator(config.getRemoteConnectionCreator());
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        this.createSearchingForTestsTask().attachTaskToProcess((OSProcessHandler)processHandler);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "startProcess"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    protected OSProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        OSProcessHandler oSProcessHandler = this.startProcess();
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "createHandler"));
        }
        return oSProcessHandler;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        ExecutionResult executionResult = this.startSMRunner(executor);
        if (executionResult != null) {
            ExecutionResult executionResult2 = executionResult;
            if (executionResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
            }
            return executionResult2;
        }
        OSProcessHandler processHandler = this.startProcess();
        final TreeRootNode unboundOutputRoot = new TreeRootNode();
        final TestNGConsoleView console = new TestNGConsoleView(this.getConfiguration(), this.getEnvironment(), unboundOutputRoot, executor);
        console.initUI();
        unboundOutputRoot.setPrinter((Printer)console.getPrinter());
        Disposer.register((Disposable)console, (Disposable)unboundOutputRoot);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)processHandler, this.getEnvironment().getRunnerSettings());
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private boolean myStarted = false;
            private int myInsertIndex = 0;

            public void processTerminated(ProcessEvent event) {
                unboundOutputRoot.flush();
            }

            public void startNotified(ProcessEvent event) {
                TestNGRemoteListener listener = new TestNGRemoteListener(console, unboundOutputRoot);
                if (TestNGRunnableState.this.getConfiguration().isSaveOutputToFile()) {
                    unboundOutputRoot.setOutputFilePath(TestNGRunnableState.this.getConfiguration().getOutputFilePath());
                }
                TestNGRunnableState.this.client.prepareListening(listener, TestNGRunnableState.this.getConfiguration().getProject(), TestNGRunnableState.this.port);
                this.myStarted = true;
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                TestNGResults resultsView = console.getResultsView();
                if (resultsView != null) {
                    resultsView.finish(this.myStarted);
                }
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                TestProxy currentTest = console.getCurrentTest();
                final String text = event.getText();
                final ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                Printable printable = new Printable(){

                    public void printOn(Printer printer) {
                        printer.print(text, consoleViewType);
                    }
                };
                if (currentTest != null) {
                    currentTest.addLast(printable);
                } else {
                    unboundOutputRoot.insert(printable, this.myInsertIndex);
                }
                ++this.myInsertIndex;
            }
        });
        console.attachToProcess((ProcessHandler)processHandler);
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)console, console.getProperties());
        rerunFailedTestsAction.setModelProvider(() -> console.getResultsView());
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        DefaultExecutionResult defaultExecutionResult = result;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        return defaultExecutionResult;
    }

    @NotNull
    protected String getFrameworkName() {
        if (TESTNG_TEST_FRAMEWORK_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "getFrameworkName"));
        }
        return TESTNG_TEST_FRAMEWORK_NAME;
    }

    protected boolean configureByModule(Module module) {
        return module != null && this.getConfiguration().getPersistantData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected void configureRTClasspath(JavaParameters javaParameters) {
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(RemoteTestNGStarter.class));
        javaParameters.getClassPath().addTail(PathUtil.getJarPathForClass(JCommander.class));
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("org.testng.RemoteTestNGStarter");
        try {
            this.port = NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException("Unable to bind to port " + this.port, (Throwable)e);
        }
        TestData data = this.getConfiguration().getPersistantData();
        javaParameters.getProgramParametersList().add(TestNGRunnableState.supportSerializationProtocol(this.getConfiguration()) ? "-serport" : "-port", String.valueOf(this.port));
        if (data.getOutputDirectory() != null && !data.getOutputDirectory().isEmpty()) {
            javaParameters.getProgramParametersList().add("-d", data.getOutputDirectory());
        }
        javaParameters.getProgramParametersList().add("-usedefaultlisteners", String.valueOf(data.USE_DEFAULT_REPORTERS));
        StringBuilder buf = new StringBuilder();
        if (data.TEST_LISTENERS != null && !data.TEST_LISTENERS.isEmpty()) {
            buf.append(StringUtil.join(data.TEST_LISTENERS, (String)";"));
        }
        this.collectListeners(javaParameters, buf, "com.theoryinpractice.testng.listener", ";");
        if (buf.length() > 0) {
            javaParameters.getProgramParametersList().add("-listener", buf.toString());
        }
        this.createServerSocket(javaParameters);
        this.createTempFiles(javaParameters);
        return javaParameters;
    }

    protected List<String> getNamedParams(String parameters) {
        try {
            Integer.parseInt(parameters);
            return super.getNamedParams(parameters);
        }
        catch (NumberFormatException e) {
            return Arrays.asList(parameters.split(" "));
        }
    }

    @NotNull
    protected String getForkMode() {
        if ("none" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "getForkMode"));
        }
        return "none";
    }

    public SearchingForTestsTask createSearchingForTestsTask() {
        return new SearchingForTestsTask(this.myServerSocket, this.config, this.myTempFile, this.client){

            @Override
            protected void onFound() {
                super.onFound();
                TestNGRunnableState.this.writeClassesPerModule(this.myClasses);
            }
        };
    }

    protected void writeClassesPerModule(Map<PsiClass, Map<PsiMethod, List<String>>> classes) {
        if (this.forkPerModule()) {
            TreeMap<Module, ArrayList<String>> perModule = new TreeMap<Module, ArrayList<String>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (PsiClass psiClass : classes.keySet()) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module == null) continue;
                ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                if (list == null) {
                    list = new ArrayList<String>();
                    perModule.put(module, list);
                }
                list.add(psiClass.getQualifiedName());
            }
            try {
                this.writeClassesPerModule(this.getConfiguration().getPackage(), this.getJavaParameters(), perModule);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static boolean supportSerializationProtocol(TestNGConfiguration config) {
        PsiClass[] starters;
        Module module;
        Project project = config.getProject();
        GlobalSearchScope scopeToDetermineTestngIn = config.getPersistantData().getScope() == TestSearchScope.WHOLE_PROJECT ? GlobalSearchScope.allScope((Project)project) : ((module = ((JavaRunConfigurationModule)config.getConfigurationModule()).getModule()) != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project));
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = facade.findClass(SerializedMessageSender.class.getName(), scopeToDetermineTestngIn);
        if (aClass == null) {
            return false;
        }
        for (PsiClass starter : starters = facade.findClasses(RemoteTestNG.class.getName(), scopeToDetermineTestngIn)) {
            if (starter.findFieldByName("m_serPort", false) != null) continue;
            LOG.info("Multiple TestNG versions found");
            return false;
        }
        return Registry.is((String)"testng.serialized.protocol.enabled") && !TestNGVersionChecker.isVersionIncompatible(project, scopeToDetermineTestngIn);
    }

    @NotNull
    protected String getFrameworkId() {
        if ("testng" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "getFrameworkId"));
        }
        return "testng";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add("-temp", tempFilePath);
    }

    @NotNull
    public TestNGConfiguration getConfiguration() {
        TestNGConfiguration testNGConfiguration = this.config;
        if (testNGConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "getConfiguration"));
        }
        return testNGConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistantData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) throws ExecutionException {
        ParametersList parametersList = parameters.getProgramParametersList();
        List params = parametersList.getParameters();
        int paramIdx = params.size() - 1;
        for (int i = 0; i < params.size(); ++i) {
            String param = (String)params.get(i);
            if (!"-temp".equals(param)) continue;
            paramIdx = i;
            break;
        }
        parametersList.addAt(paramIdx, "@@@" + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parametersList.addAt(paramIdx, "-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }
}

