/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DataProviderReturnTypeInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DataProviderReturnTypeInspection.class);

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiType returnType;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection", "checkMethod"));
        }
        String dataProviderFqn = DataProvider.class.getName();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn});
        if (annotation != null && (returnType = method.getReturnType()) != null && !DataProviderReturnTypeInspection.isSuitableReturnType(returnType)) {
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            LOG.assertTrue(returnTypeElement != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)returnTypeElement, "Data provider must return Object[][] or Iterator<Object[]>", true, DataProviderReturnTypeInspection.createFixes(method), ProblemHighlightType.ERROR)};
        }
        return null;
    }

    private static LocalQuickFix[] createFixes(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection", "createFixes"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiType iterator = elementFactory.createTypeFromText("java.util.Iterator<java.lang.Object[]>", null);
        PsiType array = elementFactory.createTypeFromText("java.lang.Object[][]", null);
        MethodReturnTypeFix iteratorFix = new MethodReturnTypeFix(method, iterator, false);
        MethodReturnTypeFix arrayFix = new MethodReturnTypeFix(method, array, false);
        return new LocalQuickFix[]{iteratorFix, arrayFix};
    }

    private static boolean isSuitableReturnType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection", "isSuitableReturnType"));
        }
        if (type instanceof PsiArrayType) {
            return DataProviderReturnTypeInspection.isObjectArray(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass resolvedClass = resolveResult.getElement();
            if (resolvedClass == null || !"java.util.Iterator".equals(resolvedClass.getQualifiedName())) {
                return false;
            }
            Map substitutionMap = resolveResult.getSubstitutor().getSubstitutionMap();
            if (substitutionMap.size() != 1) {
                return false;
            }
            PsiType genericType = (PsiType)ContainerUtil.getFirstItem(substitutionMap.values());
            if (genericType == null) {
                return false;
            }
            return DataProviderReturnTypeInspection.isObjectArray(genericType);
        }
        return false;
    }

    private static boolean isObjectArray(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection", "isObjectArray"));
        }
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        if (!(componentType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)componentType).resolve();
        if (resolvedClass == null) {
            return false;
        }
        return "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }
}

