/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestNGConsoleProperties;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.TestNGResults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGConsoleView
extends BaseTestsOutputConsoleView {
    private TestNGResults testNGResults;
    private TestProxy currentTest;
    private int myExceptionalMark = -1;
    private final TestNGConfiguration myConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final TreeRootNode myUnboundOutput;

    public TestNGConsoleView(TestNGConfiguration config, ExecutionEnvironment environment, TreeRootNode unboundOutputRoot, Executor executor) {
        super((TestConsoleProperties)new TestNGConsoleProperties(config, executor), (AbstractTestProxy)unboundOutputRoot);
        this.myConfiguration = config;
        this.myEnvironment = environment;
        this.myUnboundOutput = unboundOutputRoot;
    }

    protected TestResultsPanel createTestResultsPanel() {
        this.testNGResults = new TestNGResults(this.getConsole().getComponent(), this.myConfiguration, this);
        return this.testNGResults;
    }

    public TreeRootNode getUnboundOutput() {
        return this.myUnboundOutput;
    }

    public void initUI() {
        super.initUI();
        final TestTreeView testTreeView = this.testNGResults.getTreeView();
        testTreeView.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TestNGConsoleView.this.getPrinter().updateOnTestSelected(testTreeView.getSelectedTest());
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.testNGResults = null;
    }

    public TestNGResults getResultsView() {
        return this.testNGResults;
    }

    public void rebuildTree() {
        if (this.testNGResults != null) {
            this.testNGResults.rebuildTree();
        }
    }

    public void addTestResult(TestResultMessage result) {
        if (this.testNGResults != null) {
            int exceptionMark;
            int n = exceptionMark = this.myExceptionalMark == -1 ? 0 : this.myExceptionalMark;
            if (this.currentTest != null) {
                TestProxy failedToStart;
                String stackTrace = result.getStackTrace();
                if (stackTrace != null && stackTrace.length() > 10) {
                    exceptionMark = this.currentTest.getCurrentSize();
                    this.currentTest.appendStacktrace(result);
                }
                if ((failedToStart = this.testNGResults.getFailedToStart()) != null) {
                    this.currentTest.addChild(failedToStart);
                }
            }
            this.testNGResults.addTestResult(result, exceptionMark);
            this.myExceptionalMark = -1;
        }
    }

    public void testStarted(TestResultMessage result) {
        if (this.testNGResults != null) {
            this.currentTest = this.testNGResults.testStarted(result);
        }
    }

    public TestProxy getCurrentTest() {
        return this.currentTest;
    }

    public void finish() {
        TestProxy failedToStart;
        if (this.currentTest != null && this.testNGResults != null && (failedToStart = this.testNGResults.getFailedToStart()) != null) {
            this.currentTest.addChild(failedToStart);
            this.currentTest.setTearDownFailure(true);
            this.testNGResults.setFailedToStart(null);
        }
        this.currentTest = null;
    }
}

